/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.eventhubs.samples;

import java.io.FileReader;
import java.util.Map;
import java.util.Properties;
import org.apache.storm.Config;
import org.apache.storm.LocalCluster;
import org.apache.storm.StormSubmitter;
import org.apache.storm.eventhubs.samples.bolt.GlobalCountBolt;
import org.apache.storm.eventhubs.samples.bolt.PartialCountBolt;
import org.apache.storm.eventhubs.spout.EventHubSpout;
import org.apache.storm.eventhubs.spout.EventHubSpoutConfig;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.metric.LoggingMetricsConsumer;
import org.apache.storm.topology.BoltDeclarer;
import org.apache.storm.topology.IBasicBolt;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.topology.TopologyBuilder;

public class EventCount {
    protected EventHubSpoutConfig spoutConfig;
    protected int numWorkers;

    protected void readEHConfig(String[] args) throws Exception {
        Properties properties = new Properties();
        if (args.length > 1) {
            properties.load(new FileReader(args[1]));
        } else {
            properties.load(EventCount.class.getClassLoader().getResourceAsStream("Config.properties"));
        }
        String username = properties.getProperty("eventhubspout.username");
        String password = properties.getProperty("eventhubspout.password");
        String namespaceName = properties.getProperty("eventhubspout.namespace");
        String entityPath = properties.getProperty("eventhubspout.entitypath");
        String targetFqnAddress = properties.getProperty("eventhubspout.targetfqnaddress");
        String zkEndpointAddress = properties.getProperty("zookeeper.connectionstring");
        int partitionCount = Integer.parseInt(properties.getProperty("eventhubspout.partitions.count"));
        int checkpointIntervalInSeconds = Integer.parseInt(properties.getProperty("eventhubspout.checkpoint.interval"));
        int receiverCredits = Integer.parseInt(properties.getProperty("eventhub.receiver.credits"));
        String maxPendingMsgsPerPartitionStr = properties.getProperty("eventhubspout.max.pending.messages.per.partition");
        if (maxPendingMsgsPerPartitionStr == null) {
            maxPendingMsgsPerPartitionStr = "1024";
        }
        int maxPendingMsgsPerPartition = Integer.parseInt(maxPendingMsgsPerPartitionStr);
        String enqueueTimeDiffStr = properties.getProperty("eventhub.receiver.filter.timediff");
        if (enqueueTimeDiffStr == null) {
            enqueueTimeDiffStr = "0";
        }
        int enqueueTimeDiff = Integer.parseInt(enqueueTimeDiffStr);
        long enqueueTimeFilter = 0L;
        if (enqueueTimeDiff != 0) {
            enqueueTimeFilter = System.currentTimeMillis() - (long)(enqueueTimeDiff * 1000);
        }
        String consumerGroupName = properties.getProperty("eventhubspout.consumer.group.name");
        System.out.println("Eventhub spout config: ");
        System.out.println("  partition count: " + partitionCount);
        System.out.println("  checkpoint interval: " + checkpointIntervalInSeconds);
        System.out.println("  receiver credits: " + receiverCredits);
        this.spoutConfig = new EventHubSpoutConfig(username, password, namespaceName, entityPath, partitionCount, zkEndpointAddress, checkpointIntervalInSeconds, receiverCredits, maxPendingMsgsPerPartition, enqueueTimeFilter);
        if (targetFqnAddress != null) {
            this.spoutConfig.setTargetAddress(targetFqnAddress);
        }
        this.spoutConfig.setConsumerGroupName(consumerGroupName);
        this.numWorkers = this.spoutConfig.getPartitionCount();
        if (args.length > 0) {
            this.spoutConfig.setTopologyName(args[0]);
        }
    }

    protected EventHubSpout createEventHubSpout() {
        EventHubSpout eventHubSpout = new EventHubSpout(this.spoutConfig);
        return eventHubSpout;
    }

    protected StormTopology buildTopology(EventHubSpout eventHubSpout) {
        TopologyBuilder topologyBuilder = new TopologyBuilder();
        topologyBuilder.setSpout("EventHubsSpout", (IRichSpout)eventHubSpout, (Number)this.spoutConfig.getPartitionCount()).setNumTasks((Number)this.spoutConfig.getPartitionCount());
        ((BoltDeclarer)topologyBuilder.setBolt("PartialCountBolt", (IBasicBolt)new PartialCountBolt(), (Number)this.spoutConfig.getPartitionCount()).localOrShuffleGrouping("EventHubsSpout")).setNumTasks((Number)this.spoutConfig.getPartitionCount());
        ((BoltDeclarer)topologyBuilder.setBolt("GlobalCountBolt", (IBasicBolt)new GlobalCountBolt(), (Number)1).globalGrouping("PartialCountBolt")).setNumTasks((Number)1);
        return topologyBuilder.createTopology();
    }

    protected void submitTopology(String[] args, StormTopology topology) throws Exception {
        Config config = new Config();
        config.setDebug(false);
        config.registerMetricsConsumer(LoggingMetricsConsumer.class, 1L);
        if (args != null && args.length > 0) {
            config.setNumWorkers(this.numWorkers);
            StormSubmitter.submitTopology((String)args[0], (Map)config, (StormTopology)topology);
        } else {
            config.setMaxTaskParallelism(2);
            LocalCluster localCluster = new LocalCluster();
            localCluster.submitTopology("test", (Map)config, topology);
            Thread.sleep(5000000L);
            localCluster.shutdown();
        }
    }

    protected void runScenario(String[] args) throws Exception {
        this.readEHConfig(args);
        EventHubSpout eventHubSpout = this.createEventHubSpout();
        StormTopology topology = this.buildTopology(eventHubSpout);
        this.submitTopology(args, topology);
    }

    public static void main(String[] args) throws Exception {
        EventCount scenario = new EventCount();
        scenario.runScenario(args);
    }
}

