/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.eventhubs.bolt;

import com.microsoft.eventhubs.client.ConnectionStringBuilder;
import java.io.Serializable;
import org.apache.storm.eventhubs.bolt.DefaultEventDataFormat;
import org.apache.storm.eventhubs.bolt.IEventDataFormat;

public class EventHubBoltConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String connectionString;
    private final String entityPath;
    protected boolean partitionMode;
    protected IEventDataFormat dataFormat;

    public EventHubBoltConfig(String connectionString, String entityPath) {
        this(connectionString, entityPath, false, null);
    }

    public EventHubBoltConfig(String connectionString, String entityPath, boolean partitionMode) {
        this(connectionString, entityPath, partitionMode, null);
    }

    public EventHubBoltConfig(String userName, String password, String namespace, String entityPath, boolean partitionMode) {
        this(userName, password, namespace, "servicebus.windows.net", entityPath, partitionMode);
    }

    public EventHubBoltConfig(String connectionString, String entityPath, boolean partitionMode, IEventDataFormat dataFormat) {
        this.connectionString = connectionString;
        this.entityPath = entityPath;
        this.partitionMode = partitionMode;
        this.dataFormat = dataFormat;
        if (this.dataFormat == null) {
            this.dataFormat = new DefaultEventDataFormat();
        }
    }

    public EventHubBoltConfig(String userName, String password, String namespace, String targetFqnAddress, String entityPath) {
        this(userName, password, namespace, targetFqnAddress, entityPath, false, null);
    }

    public EventHubBoltConfig(String userName, String password, String namespace, String targetFqnAddress, String entityPath, boolean partitionMode) {
        this(userName, password, namespace, targetFqnAddress, entityPath, partitionMode, null);
    }

    public EventHubBoltConfig(String userName, String password, String namespace, String targetFqnAddress, String entityPath, boolean partitionMode, IEventDataFormat dataFormat) {
        this.connectionString = new ConnectionStringBuilder(userName, password, namespace, targetFqnAddress).getConnectionString();
        this.entityPath = entityPath;
        this.partitionMode = partitionMode;
        this.dataFormat = dataFormat;
        if (this.dataFormat == null) {
            this.dataFormat = new DefaultEventDataFormat();
        }
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public String getEntityPath() {
        return this.entityPath;
    }

    public boolean getPartitionMode() {
        return this.partitionMode;
    }

    public IEventDataFormat getEventDataFormat() {
        return this.dataFormat;
    }
}

