/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.eventhubs.bolt;

import com.microsoft.eventhubs.client.EventHubClient;
import com.microsoft.eventhubs.client.EventHubException;
import com.microsoft.eventhubs.client.EventHubSender;
import java.util.Map;
import org.apache.storm.eventhubs.bolt.EventHubBoltConfig;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseTickTupleAwareRichBolt;
import org.apache.storm.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHubBolt
extends BaseTickTupleAwareRichBolt {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(EventHubBolt.class);
    protected OutputCollector collector;
    protected EventHubSender sender;
    protected EventHubBoltConfig boltConfig;

    public EventHubBolt(String connectionString, String entityPath) {
        this.boltConfig = new EventHubBoltConfig(connectionString, entityPath);
    }

    public EventHubBolt(String userName, String password, String namespace, String entityPath, boolean partitionMode) {
        this.boltConfig = new EventHubBoltConfig(userName, password, namespace, entityPath, partitionMode);
    }

    public EventHubBolt(EventHubBoltConfig config) {
        this.boltConfig = config;
    }

    public void prepare(Map config, TopologyContext context, OutputCollector collector) {
        this.collector = collector;
        String myPartitionId = null;
        if (this.boltConfig.getPartitionMode()) {
            myPartitionId = "" + context.getThisTaskIndex();
        }
        logger.info("creating sender: " + this.boltConfig.getConnectionString() + ", " + this.boltConfig.getEntityPath() + ", " + myPartitionId);
        try {
            EventHubClient eventHubClient = EventHubClient.create((String)this.boltConfig.getConnectionString(), (String)this.boltConfig.getEntityPath());
            this.sender = eventHubClient.createPartitionSender(myPartitionId);
        }
        catch (Exception ex) {
            collector.reportError((Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    protected void process(Tuple tuple) {
        try {
            this.sender.send(this.boltConfig.getEventDataFormat().serialize(tuple));
            this.collector.ack(tuple);
        }
        catch (EventHubException ex) {
            this.collector.reportError((Throwable)ex);
            this.collector.fail(tuple);
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
    }
}

