/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hive.common;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.hcatalog.streaming.ConnectionError;
import org.apache.hive.hcatalog.streaming.HiveEndPoint;
import org.apache.storm.hive.common.HiveOptions;
import org.apache.storm.hive.common.HiveWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HiveUtils.class);

    public static HiveEndPoint makeEndPoint(List<String> partitionVals, HiveOptions options) throws ConnectionError {
        if (partitionVals == null) {
            return new HiveEndPoint(options.getMetaStoreURI(), options.getDatabaseName(), options.getTableName(), null);
        }
        return new HiveEndPoint(options.getMetaStoreURI(), options.getDatabaseName(), options.getTableName(), partitionVals);
    }

    public static HiveWriter makeHiveWriter(HiveEndPoint endPoint, ExecutorService callTimeoutPool, UserGroupInformation ugi, HiveOptions options) throws HiveWriter.ConnectFailure, InterruptedException {
        return new HiveWriter(endPoint, options.getTxnsPerBatch(), options.getAutoCreatePartitions(), options.getCallTimeOut().intValue(), callTimeoutPool, options.getMapper(), ugi);
    }

    public static synchronized UserGroupInformation authenticate(String keytab, String principal) throws AuthenticationFailed {
        File kfile = new File(keytab);
        if (!kfile.isFile() || !kfile.canRead()) {
            throw new IllegalArgumentException("The keyTab file: " + keytab + " is nonexistent or can't read. Please specify a readable keytab file for Kerberos auth.");
        }
        try {
            principal = SecurityUtil.getServerPrincipal((String)principal, (String)"");
        }
        catch (Exception e) {
            throw new AuthenticationFailed("Host lookup error when resolving principal " + principal, e);
        }
        try {
            UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab);
            return UserGroupInformation.getLoginUser();
        }
        catch (IOException e) {
            throw new AuthenticationFailed("Login failed for principal " + principal, e);
        }
    }

    public static void logAllHiveEndPoints(Map<HiveEndPoint, HiveWriter> allWriters) {
        for (Map.Entry<HiveEndPoint, HiveWriter> entry : allWriters.entrySet()) {
            LOG.info("cached writers {} ", (Object)entry.getValue());
        }
    }

    public static class AuthenticationFailed
    extends Exception {
        public AuthenticationFailed(String reason, Exception cause) {
            super("Kerberos Authentication Failed. " + reason, cause);
        }
    }
}

