/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hive.trident;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.Config;
import org.apache.storm.LocalCluster;
import org.apache.storm.StormSubmitter;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.hive.bolt.mapper.DelimitedRecordHiveMapper;
import org.apache.storm.hive.bolt.mapper.HiveMapper;
import org.apache.storm.hive.common.HiveOptions;
import org.apache.storm.hive.trident.HiveStateFactory;
import org.apache.storm.hive.trident.HiveUpdater;
import org.apache.storm.hooks.SubmitterHookException;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.trident.Stream;
import org.apache.storm.trident.TridentState;
import org.apache.storm.trident.TridentTopology;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.spout.IBatchSpout;
import org.apache.storm.trident.state.StateFactory;
import org.apache.storm.trident.state.StateUpdater;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TridentHiveTopology {
    private static final Logger LOG = LoggerFactory.getLogger(TridentHiveTopology.class);

    public static StormTopology buildTopology(String metaStoreURI, String dbName, String tblName, Object keytab, Object principal) {
        int batchSize = 100;
        FixedBatchSpout spout = new FixedBatchSpout(batchSize);
        spout.setCycle(true);
        TridentTopology topology = new TridentTopology();
        Stream stream = topology.newStream("hiveTridentspout1", (IBatchSpout)spout);
        String[] partNames = new String[]{"city", "state"};
        String[] colNames = new String[]{"id", "name", "phone", "street"};
        Fields hiveFields = new Fields(new String[]{"id", "name", "phone", "street", "city", "state"});
        DelimitedRecordHiveMapper mapper = new DelimitedRecordHiveMapper().withColumnFields(new Fields(colNames)).withPartitionFields(new Fields(partNames));
        HiveOptions hiveOptions = keytab != null && principal != null ? new HiveOptions(metaStoreURI, dbName, tblName, (HiveMapper)mapper).withTxnsPerBatch(Integer.valueOf(10)).withBatchSize(Integer.valueOf(batchSize)).withIdleTimeout(Integer.valueOf(10)).withCallTimeout(Integer.valueOf(30000)).withKerberosKeytab((String)keytab).withKerberosPrincipal((String)principal) : new HiveOptions(metaStoreURI, dbName, tblName, (HiveMapper)mapper).withTxnsPerBatch(Integer.valueOf(10)).withBatchSize(Integer.valueOf(batchSize)).withCallTimeout(Integer.valueOf(30000)).withIdleTimeout(Integer.valueOf(10));
        HiveStateFactory factory = new HiveStateFactory().withOptions(hiveOptions);
        TridentState state = stream.partitionPersist((StateFactory)factory, hiveFields, (StateUpdater)new HiveUpdater(), new Fields(new String[0]));
        return topology.build();
    }

    public static void waitForSeconds(int seconds) {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        String metaStoreURI = args[0];
        String dbName = args[1];
        String tblName = args[2];
        Config conf = new Config();
        conf.setMaxSpoutPending(5);
        if (args.length == 3) {
            LocalCluster cluster = new LocalCluster();
            cluster.submitTopology("tridentHiveTopology", (Map)conf, TridentHiveTopology.buildTopology(metaStoreURI, dbName, tblName, null, null));
            LOG.info("waiting for 60 seconds");
            TridentHiveTopology.waitForSeconds(60);
            LOG.info("killing topology");
            cluster.killTopology("tridenHiveTopology");
            LOG.info("cluster shutdown");
            cluster.shutdown();
            LOG.info("cluster shutdown");
            System.exit(0);
        } else if (args.length == 4) {
            try {
                StormSubmitter.submitTopology((String)args[3], (Map)conf, (StormTopology)TridentHiveTopology.buildTopology(metaStoreURI, dbName, tblName, null, null));
            }
            catch (SubmitterHookException e) {
                LOG.warn("Topology is submitted but invoking ISubmitterHook failed", (Throwable)e);
            }
            catch (Exception e) {
                LOG.warn("Failed to submit topology ", (Throwable)e);
            }
        } else if (args.length == 6) {
            try {
                StormSubmitter.submitTopology((String)args[3], (Map)conf, (StormTopology)TridentHiveTopology.buildTopology(metaStoreURI, dbName, tblName, args[4], args[5]));
            }
            catch (SubmitterHookException e) {
                LOG.warn("Topology is submitted but invoking ISubmitterHook failed", (Throwable)e);
            }
            catch (Exception e) {
                LOG.warn("Failed to submit topology ", (Throwable)e);
            }
        } else {
            LOG.info("Usage: TridentHiveTopology metastoreURI dbName tableName [topologyNamey]");
        }
    }

    public static class FixedBatchSpout
    implements IBatchSpout {
        int maxBatchSize;
        HashMap<Long, List<List<Object>>> batches = new HashMap();
        private Values[] outputs = new Values[]{new Values(new Object[]{"1", "user1", "123456", "street1", "sunnyvale", "ca"}), new Values(new Object[]{"2", "user2", "123456", "street2", "sunnyvale", "ca"}), new Values(new Object[]{"3", "user3", "123456", "street3", "san jose", "ca"}), new Values(new Object[]{"4", "user4", "123456", "street4", "san jose", "ca"})};
        private int index = 0;
        boolean cycle = false;

        public FixedBatchSpout(int maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
        }

        public void setCycle(boolean cycle) {
            this.cycle = cycle;
        }

        public Fields getOutputFields() {
            return new Fields(new String[]{"id", "name", "phone", "street", "city", "state"});
        }

        public void open(Map conf, TopologyContext context) {
            this.index = 0;
        }

        public void emitBatch(long batchId, TridentCollector collector) {
            List<List<Object>> batch = this.batches.get(batchId);
            if (batch == null) {
                batch = new ArrayList<List<Object>>();
                if (this.index >= this.outputs.length && this.cycle) {
                    this.index = 0;
                }
                for (int i = 0; i < this.maxBatchSize; ++i) {
                    if (this.index == this.outputs.length) {
                        this.index = 0;
                    }
                    batch.add((List<Object>)this.outputs[this.index]);
                    ++this.index;
                }
                this.batches.put(batchId, batch);
            }
            for (List<Object> list : batch) {
                collector.emit(list);
            }
        }

        public void ack(long batchId) {
            this.batches.remove(batchId);
        }

        public void close() {
        }

        public Map getComponentConfiguration() {
            Config conf = new Config();
            conf.setMaxTaskParallelism(1);
            return conf;
        }
    }
}

