/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hive.common;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import junit.framework.Assert;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.txn.TxnDbUtil;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.hcatalog.streaming.HiveEndPoint;
import org.apache.hive.hcatalog.streaming.SerializationError;
import org.apache.storm.Config;
import org.apache.storm.hive.bolt.HiveSetupUtil;
import org.apache.storm.hive.bolt.mapper.DelimitedRecordHiveMapper;
import org.apache.storm.hive.bolt.mapper.HiveMapper;
import org.apache.storm.hive.common.HiveWriter;
import org.apache.storm.task.GeneralTopologyContext;
import org.apache.storm.topology.TopologyBuilder;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.TupleImpl;
import org.apache.storm.tuple.Values;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestHiveWriter {
    static final String dbName = "testdb";
    static final String tblName = "test_table2";
    public static final String PART1_NAME = "city";
    public static final String PART2_NAME = "state";
    public static final String[] partNames = new String[]{"city", "state"};
    final String[] partitionVals = new String[]{"sunnyvale", "ca"};
    final String[] colNames = new String[]{"id", "msg"};
    private String[] colTypes = new String[]{"int", "string"};
    private final int port;
    private final String metaStoreURI;
    private final HiveConf conf;
    private ExecutorService callTimeoutPool;
    private final Driver driver;
    int timeout = 10000;
    UserGroupInformation ugi = null;
    @Rule
    public TemporaryFolder dbFolder = new TemporaryFolder();

    public TestHiveWriter() throws Exception {
        this.port = 9083;
        this.metaStoreURI = null;
        int callTimeoutPoolSize = 1;
        this.callTimeoutPool = Executors.newFixedThreadPool(callTimeoutPoolSize, new ThreadFactoryBuilder().setNameFormat("hiveWriterTest").build());
        this.conf = HiveSetupUtil.getHiveConf();
        TxnDbUtil.setConfValues((HiveConf)this.conf);
        TxnDbUtil.cleanDb();
        TxnDbUtil.prepDb();
        if (this.metaStoreURI != null) {
            this.conf.setVar(HiveConf.ConfVars.METASTOREURIS, this.metaStoreURI);
        }
        SessionState.start((SessionState)new CliSessionState(this.conf));
        this.driver = new Driver(this.conf);
        this.driver.init();
    }

    @Before
    public void setUp() throws Exception {
        HiveSetupUtil.dropDB(this.conf, dbName);
        String dbLocation = this.dbFolder.newFolder(dbName).getCanonicalPath() + ".db";
        HiveSetupUtil.createDbAndTable(this.conf, dbName, tblName, Arrays.asList(this.partitionVals), this.colNames, this.colTypes, partNames, dbLocation);
    }

    @Test
    public void testInstantiate() throws Exception {
        DelimitedRecordHiveMapper mapper = new DelimitedRecordHiveMapper().withColumnFields(new Fields(this.colNames)).withPartitionFields(new Fields(partNames));
        HiveEndPoint endPoint = new HiveEndPoint(this.metaStoreURI, dbName, tblName, Arrays.asList(this.partitionVals));
        HiveWriter writer = new HiveWriter(endPoint, 10, true, (long)this.timeout, this.callTimeoutPool, (HiveMapper)mapper, this.ugi);
        writer.close();
    }

    @Test
    public void testWriteBasic() throws Exception {
        DelimitedRecordHiveMapper mapper = new DelimitedRecordHiveMapper().withColumnFields(new Fields(this.colNames)).withPartitionFields(new Fields(partNames));
        HiveEndPoint endPoint = new HiveEndPoint(this.metaStoreURI, dbName, tblName, Arrays.asList(this.partitionVals));
        HiveWriter writer = new HiveWriter(endPoint, 10, true, (long)this.timeout, this.callTimeoutPool, (HiveMapper)mapper, this.ugi);
        this.writeTuples(writer, (HiveMapper)mapper, 3);
        writer.flush(false);
        writer.close();
        this.checkRecordCountInTable(dbName, tblName, 3);
    }

    @Test
    public void testWriteMultiFlush() throws Exception {
        DelimitedRecordHiveMapper mapper = new DelimitedRecordHiveMapper().withColumnFields(new Fields(this.colNames)).withPartitionFields(new Fields(partNames));
        HiveEndPoint endPoint = new HiveEndPoint(this.metaStoreURI, dbName, tblName, Arrays.asList(this.partitionVals));
        HiveWriter writer = new HiveWriter(endPoint, 10, true, (long)this.timeout, this.callTimeoutPool, (HiveMapper)mapper, this.ugi);
        Tuple tuple = this.generateTestTuple("1", "abc");
        writer.write(mapper.mapRecord(tuple));
        tuple = this.generateTestTuple("2", "def");
        writer.write(mapper.mapRecord(tuple));
        Assert.assertEquals((int)writer.getTotalRecords(), (int)2);
        this.checkRecordCountInTable(dbName, tblName, 0);
        writer.flush(true);
        Assert.assertEquals((int)writer.getTotalRecords(), (int)0);
        tuple = this.generateTestTuple("3", "ghi");
        writer.write(mapper.mapRecord(tuple));
        writer.flush(true);
        tuple = this.generateTestTuple("4", "klm");
        writer.write(mapper.mapRecord(tuple));
        writer.flush(true);
        writer.close();
        this.checkRecordCountInTable(dbName, tblName, 4);
    }

    private Tuple generateTestTuple(Object id, Object msg) {
        TopologyBuilder builder = new TopologyBuilder();
        GeneralTopologyContext topologyContext = new GeneralTopologyContext(builder.createTopology(), (Map)new Config(), new HashMap(), new HashMap(), new HashMap(), ""){

            public Fields getComponentOutputFields(String componentId, String streamId) {
                return new Fields(new String[]{"id", "msg"});
            }
        };
        return new TupleImpl(topologyContext, (List)new Values(new Object[]{id, msg}), 1, "");
    }

    private void writeTuples(HiveWriter writer, HiveMapper mapper, int count) throws HiveWriter.WriteFailure, InterruptedException, SerializationError {
        Integer id = 100;
        String msg = "test-123";
        for (int i = 1; i <= count; ++i) {
            Tuple tuple = this.generateTestTuple(id, msg);
            writer.write(mapper.mapRecord(tuple));
        }
    }

    private void checkRecordCountInTable(String dbName, String tableName, int expectedCount) throws CommandNeedRetryException, IOException {
        int count = this.listRecordsInTable(dbName, tableName).size();
        Assert.assertEquals((int)expectedCount, (int)count);
    }

    private ArrayList<String> listRecordsInTable(String dbName, String tableName) throws CommandNeedRetryException, IOException {
        this.driver.compile("select * from " + dbName + "." + tableName);
        ArrayList<String> res = new ArrayList<String>();
        this.driver.getResults(res);
        return res;
    }
}

