/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hive.bolt;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.storm.Config;
import org.apache.storm.LocalCluster;
import org.apache.storm.StormSubmitter;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.hive.bolt.HiveBolt;
import org.apache.storm.hive.bolt.mapper.DelimitedRecordHiveMapper;
import org.apache.storm.hive.bolt.mapper.HiveMapper;
import org.apache.storm.hive.common.HiveOptions;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.TopologyBuilder;
import org.apache.storm.topology.base.BaseRichSpout;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;
import org.apache.storm.utils.Utils;

public class HiveTopologyPartitioned {
    static final String USER_SPOUT_ID = "hive-user-spout-partitioned";
    static final String BOLT_ID = "my-hive-bolt-partitioned";
    static final String TOPOLOGY_NAME = "hive-test-topology-partitioned";

    public static void main(String[] args) throws Exception {
        String metaStoreURI = args[0];
        String dbName = args[1];
        String tblName = args[2];
        String[] partNames = new String[]{"city", "state"};
        String[] colNames = new String[]{"id", "name", "phone", "street"};
        Config config = new Config();
        config.setNumWorkers(1);
        UserDataSpout spout = new UserDataSpout();
        DelimitedRecordHiveMapper mapper = new DelimitedRecordHiveMapper().withColumnFields(new Fields(colNames)).withPartitionFields(new Fields(partNames));
        HiveOptions hiveOptions = args.length == 6 ? new HiveOptions(metaStoreURI, dbName, tblName, (HiveMapper)mapper).withTxnsPerBatch(Integer.valueOf(10)).withBatchSize(Integer.valueOf(1000)).withIdleTimeout(Integer.valueOf(10)).withKerberosKeytab(args[4]).withKerberosPrincipal(args[5]) : new HiveOptions(metaStoreURI, dbName, tblName, (HiveMapper)mapper).withTxnsPerBatch(Integer.valueOf(10)).withBatchSize(Integer.valueOf(1000)).withIdleTimeout(Integer.valueOf(10));
        HiveBolt hiveBolt = new HiveBolt(hiveOptions);
        TopologyBuilder builder = new TopologyBuilder();
        builder.setSpout(USER_SPOUT_ID, (IRichSpout)spout, (Number)1);
        builder.setBolt(BOLT_ID, (IRichBolt)hiveBolt, (Number)1).shuffleGrouping(USER_SPOUT_ID);
        if (args.length == 3) {
            LocalCluster cluster = new LocalCluster();
            cluster.submitTopology(TOPOLOGY_NAME, (Map)config, builder.createTopology());
            HiveTopologyPartitioned.waitForSeconds(20);
            cluster.killTopology(TOPOLOGY_NAME);
            System.out.println("cluster begin to shutdown");
            cluster.shutdown();
            System.out.println("cluster shutdown");
            System.exit(0);
        } else if (args.length >= 4) {
            StormSubmitter.submitTopology((String)args[3], (Map)config, (StormTopology)builder.createTopology());
        } else {
            System.out.println("Usage: HiveTopologyPartitioned metastoreURI dbName tableName [topologyNamey] [keytab file] [principal name]");
        }
    }

    public static void waitForSeconds(int seconds) {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static class UserDataSpout
    extends BaseRichSpout {
        private ConcurrentHashMap<UUID, Values> pending;
        private SpoutOutputCollector collector;
        private String[] sentences = new String[]{"1,user1,123456,street1,sunnyvale,ca", "2,user2,123456,street2,sunnyvale,ca", "3,user3,123456,street3,san jose,ca", "4,user4,123456,street4,san jose,ca"};
        private int index = 0;
        private int count = 0;
        private long total = 0L;

        public void declareOutputFields(OutputFieldsDeclarer declarer) {
            declarer.declare(new Fields(new String[]{"id", "name", "phone", "street", "city", "state"}));
        }

        public void open(Map config, TopologyContext context, SpoutOutputCollector collector) {
            this.collector = collector;
            this.pending = new ConcurrentHashMap();
        }

        public void nextTuple() {
            String[] user = this.sentences[this.index].split(",");
            Values values = new Values(new Object[]{Integer.parseInt(user[0]), user[1], user[2], user[3], user[4], user[5]});
            UUID msgId = UUID.randomUUID();
            this.pending.put(msgId, values);
            this.collector.emit((List)values, (Object)msgId);
            ++this.index;
            if (this.index >= this.sentences.length) {
                this.index = 0;
            }
            ++this.count;
            ++this.total;
            if (this.count > 1000) {
                Utils.sleep((long)1000L);
                this.count = 0;
                System.out.println("Pending count: " + this.pending.size() + ", total: " + this.total);
            }
        }

        public void ack(Object msgId) {
            this.pending.remove(msgId);
        }

        public void fail(Object msgId) {
            System.out.println("**** RESENDING FAILED TUPLE");
            this.collector.emit((List)this.pending.get(msgId), msgId);
        }
    }
}

