/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hive.bolt;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.thrift.TException;

public class HiveSetupUtil {
    private static final String txnMgr = "org.apache.hadoop.hive.ql.lockmgr.DbTxnManager";

    public static HiveConf getHiveConf() {
        HiveConf conf = new HiveConf();
        conf.set("fs.raw.impl", RawFileSystem.class.getName());
        conf.setVar(HiveConf.ConfVars.HIVE_TXN_MANAGER, txnMgr);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, true);
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDbAndTable(HiveConf conf, String databaseName, String tableName, List<String> partVals, String[] colNames, String[] colTypes, String[] partNames, String dbLocation) throws Exception {
        try (HiveMetaStoreClient client = new HiveMetaStoreClient(conf);){
            Database db = new Database();
            db.setName(databaseName);
            db.setLocationUri(dbLocation);
            client.createDatabase(db);
            Table tbl = new Table();
            tbl.setDbName(databaseName);
            tbl.setTableName(tableName);
            tbl.setTableType(TableType.MANAGED_TABLE.toString());
            StorageDescriptor sd = new StorageDescriptor();
            sd.setCols(HiveSetupUtil.getTableColumns(colNames, colTypes));
            sd.setNumBuckets(1);
            sd.setLocation(dbLocation + "/" + tableName);
            if (partNames != null && partNames.length != 0) {
                tbl.setPartitionKeys(HiveSetupUtil.getPartitionKeys(partNames));
            }
            tbl.setSd(sd);
            sd.setBucketCols(new ArrayList(2));
            sd.setSerdeInfo(new SerDeInfo());
            sd.getSerdeInfo().setName(tbl.getTableName());
            sd.getSerdeInfo().setParameters(new HashMap());
            sd.getSerdeInfo().getParameters().put("serialization.format", "1");
            sd.getSerdeInfo().setSerializationLib(OrcSerde.class.getName());
            sd.setInputFormat(OrcInputFormat.class.getName());
            sd.setOutputFormat(OrcOutputFormat.class.getName());
            HashMap tableParams = new HashMap();
            tbl.setParameters(tableParams);
            client.createTable(tbl);
            try {
                if (partVals != null && partVals.size() > 0) {
                    HiveSetupUtil.addPartition((IMetaStoreClient)client, tbl, partVals);
                }
            }
            catch (AlreadyExistsException alreadyExistsException) {
                // empty catch block
            }
        }
    }

    public static void dropDB(HiveConf conf, String databaseName) throws HiveException, MetaException {
        HiveMetaStoreClient client = new HiveMetaStoreClient(conf);
        try {
            for (String table : client.listTableNamesByFilter(databaseName, "", (short)-1)) {
                client.dropTable(databaseName, table, true, true);
            }
            client.dropDatabase(databaseName);
        }
        catch (TException e) {
            client.close();
        }
    }

    private static void addPartition(IMetaStoreClient client, Table tbl, List<String> partValues) throws IOException, TException {
        Partition part = new Partition();
        part.setDbName(tbl.getDbName());
        part.setTableName(tbl.getTableName());
        StorageDescriptor sd = new StorageDescriptor(tbl.getSd());
        sd.setLocation(sd.getLocation() + "/" + HiveSetupUtil.makePartPath(tbl.getPartitionKeys(), partValues));
        part.setSd(sd);
        part.setValues(partValues);
        client.add_partition(part);
    }

    private static String makePartPath(List<FieldSchema> partKeys, List<String> partVals) {
        if (partKeys.size() != partVals.size()) {
            throw new IllegalArgumentException("Partition values:" + partVals + ", does not match the partition Keys in table :" + partKeys);
        }
        StringBuffer buff = new StringBuffer(partKeys.size() * 20);
        int i = 0;
        for (FieldSchema schema : partKeys) {
            buff.append(schema.getName());
            buff.append("=");
            buff.append(partVals.get(i));
            if (i != partKeys.size() - 1) {
                buff.append("/");
            }
            ++i;
        }
        return buff.toString();
    }

    private static List<FieldSchema> getTableColumns(String[] colNames, String[] colTypes) {
        ArrayList<FieldSchema> fields = new ArrayList<FieldSchema>();
        for (int i = 0; i < colNames.length; ++i) {
            fields.add(new FieldSchema(colNames[i], colTypes[i], ""));
        }
        return fields;
    }

    private static List<FieldSchema> getPartitionKeys(String[] partNames) {
        ArrayList<FieldSchema> fields = new ArrayList<FieldSchema>();
        for (int i = 0; i < partNames.length; ++i) {
            fields.add(new FieldSchema(partNames[i], "string", ""));
        }
        return fields;
    }

    public static class RawFileSystem
    extends RawLocalFileSystem {
        private static final URI NAME;

        public URI getUri() {
            return NAME;
        }

        public FileStatus getFileStatus(Path path) throws IOException {
            File file = this.pathToFile(path);
            if (!file.exists()) {
                throw new FileNotFoundException("Can't find " + path);
            }
            short mod = 0;
            if (file.canRead()) {
                mod = (short)(mod | 0x124);
            }
            if (file.canWrite()) {
                mod = (short)(mod | 0x80);
            }
            if (file.canExecute()) {
                mod = (short)(mod | 0x49);
            }
            ShimLoader.getHadoopShims();
            return new FileStatus(file.length(), file.isDirectory(), 1, 1024L, file.lastModified(), file.lastModified(), FsPermission.createImmutable((short)mod), "owen", "users", path);
        }

        static {
            try {
                NAME = new URI("raw:///");
            }
            catch (URISyntaxException se) {
                throw new IllegalArgumentException("bad uri", se);
            }
        }
    }
}

