/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.mongodb.trident.state;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.storm.mongodb.common.MongoDBClient;
import org.apache.storm.mongodb.common.mapper.MongoMapper;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.state.State;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.tuple.ITuple;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoState
implements State {
    private static final Logger LOG = LoggerFactory.getLogger(MongoState.class);
    private Options options;
    private MongoDBClient mongoClient;
    private Map map;

    protected MongoState(Map map, Options options) {
        this.options = options;
        this.map = map;
    }

    protected void prepare() {
        Validate.notEmpty((String)this.options.url, (String)"url can not be blank or null");
        Validate.notEmpty((String)this.options.collectionName, (String)"collectionName can not be blank or null");
        Validate.notNull((Object)this.options.mapper, (String)"MongoMapper can not be null");
        this.mongoClient = new MongoDBClient(this.options.url, this.options.collectionName);
    }

    public void beginCommit(Long txid) {
        LOG.debug("beginCommit is noop.");
    }

    public void commit(Long txid) {
        LOG.debug("commit is noop.");
    }

    public void updateState(List<TridentTuple> tuples, TridentCollector collector) {
        ArrayList documents = Lists.newArrayList();
        for (TridentTuple tuple : tuples) {
            Document document = this.options.mapper.toDocument((ITuple)tuple);
            documents.add(document);
        }
        this.mongoClient.insert(documents, true);
    }

    public static class Options
    implements Serializable {
        private String url;
        private String collectionName;
        private MongoMapper mapper;

        public Options withUrl(String url) {
            this.url = url;
            return this;
        }

        public Options withCollectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public Options withMapper(MongoMapper mapper) {
            this.mapper = mapper;
            return this;
        }
    }
}

