/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.mongodb.common;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.UpdateOptions;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoDBClient {
    private MongoClient client;
    private MongoCollection<Document> collection;

    public MongoDBClient(String url, String collectionName) {
        MongoClientURI uri = new MongoClientURI(url);
        this.client = new MongoClient(uri);
        MongoDatabase db = this.client.getDatabase(uri.getDatabase());
        this.collection = db.getCollection(collectionName);
    }

    public void insert(List<Document> documents, boolean ordered) {
        InsertManyOptions options = new InsertManyOptions();
        if (!ordered) {
            options.ordered(false);
        }
        this.collection.insertMany(documents, options);
    }

    public void update(Bson filter, Bson update, boolean upsert) {
        UpdateOptions options = new UpdateOptions();
        if (upsert) {
            options.upsert(true);
        }
        this.collection.updateMany(filter, update, options);
    }

    public void close() {
        this.client.close();
    }
}

