/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.mongodb.bolt;

import org.apache.commons.lang.Validate;
import org.apache.storm.mongodb.bolt.AbstractMongoBolt;
import org.apache.storm.mongodb.common.QueryFilterCreator;
import org.apache.storm.mongodb.common.mapper.MongoMapper;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.ITuple;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.utils.TupleUtils;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoUpdateBolt
extends AbstractMongoBolt {
    private QueryFilterCreator queryCreator;
    private MongoMapper mapper;
    private boolean upsert;

    public MongoUpdateBolt(String url, String collectionName, QueryFilterCreator queryCreator, MongoMapper mapper) {
        super(url, collectionName);
        Validate.notNull((Object)queryCreator, (String)"QueryFilterCreator can not be null");
        Validate.notNull((Object)mapper, (String)"MongoMapper can not be null");
        this.queryCreator = queryCreator;
        this.mapper = mapper;
    }

    public void execute(Tuple tuple) {
        if (TupleUtils.isTick((Tuple)tuple)) {
            return;
        }
        try {
            Document doc = this.mapper.toDocument((ITuple)tuple);
            Bson filter = this.queryCreator.createFilter((ITuple)tuple);
            this.mongoClient.update(filter, (Bson)doc, this.upsert);
            this.collector.ack(tuple);
        }
        catch (Exception e) {
            this.collector.reportError((Throwable)e);
            this.collector.fail(tuple);
        }
    }

    public MongoUpdateBolt withUpsert(boolean upsert) {
        this.upsert = upsert;
        return this;
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
    }
}

