/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.mongodb.bolt;

import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.storm.mongodb.bolt.AbstractMongoBolt;
import org.apache.storm.mongodb.common.mapper.MongoMapper;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.ITuple;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.utils.BatchHelper;
import org.apache.storm.utils.TupleUtils;
import org.bson.Document;

public class MongoInsertBolt
extends AbstractMongoBolt {
    private static final int DEFAULT_FLUSH_INTERVAL_SECS = 1;
    private MongoMapper mapper;
    private boolean ordered = true;
    private int batchSize;
    private BatchHelper batchHelper;
    private int flushIntervalSecs = 1;

    public MongoInsertBolt(String url, String collectionName, MongoMapper mapper) {
        super(url, collectionName);
        Validate.notNull((Object)mapper, (String)"MongoMapper can not be null");
        this.mapper = mapper;
    }

    public void execute(Tuple tuple) {
        try {
            if (this.batchHelper.shouldHandle(tuple)) {
                this.batchHelper.addBatch(tuple);
            }
            if (this.batchHelper.shouldFlush()) {
                this.flushTuples();
                this.batchHelper.ack();
            }
        }
        catch (Exception e) {
            this.batchHelper.fail(e);
        }
    }

    private void flushTuples() {
        LinkedList<Document> docs = new LinkedList<Document>();
        for (Tuple t : this.batchHelper.getBatchTuples()) {
            Document doc = this.mapper.toDocument((ITuple)t);
            docs.add(doc);
        }
        this.mongoClient.insert(docs, this.ordered);
    }

    public MongoInsertBolt withBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public MongoInsertBolt withOrdered(boolean ordered) {
        this.ordered = ordered;
        return this;
    }

    public MongoInsertBolt withFlushIntervalSecs(int flushIntervalSecs) {
        this.flushIntervalSecs = flushIntervalSecs;
        return this;
    }

    public Map<String, Object> getComponentConfiguration() {
        return TupleUtils.putTickFrequencyIntoComponentConfig((Map)super.getComponentConfiguration(), (int)this.flushIntervalSecs);
    }

    @Override
    public void prepare(Map stormConf, TopologyContext context, OutputCollector collector) {
        super.prepare(stormConf, context, collector);
        this.batchHelper = new BatchHelper(this.batchSize, collector);
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
    }
}

