/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.mongodb.bolt;

import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.storm.mongodb.common.MongoDBClient;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.base.BaseRichBolt;

public abstract class AbstractMongoBolt
extends BaseRichBolt {
    private String url;
    private String collectionName;
    protected OutputCollector collector;
    protected MongoDBClient mongoClient;

    public AbstractMongoBolt(String url, String collectionName) {
        Validate.notEmpty((String)url, (String)"url can not be blank or null");
        Validate.notEmpty((String)collectionName, (String)"collectionName can not be blank or null");
        this.url = url;
        this.collectionName = collectionName;
    }

    public void prepare(Map stormConf, TopologyContext context, OutputCollector collector) {
        this.collector = collector;
        this.mongoClient = new MongoDBClient(this.url, this.collectionName);
    }

    public void cleanup() {
        this.mongoClient.close();
    }
}

