/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout.trident;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.apache.storm.kafka.spout.SpoutWithMockedConsumerSetupHelper;
import org.apache.storm.kafka.spout.trident.KafkaTridentSpoutBatchMetadata;
import org.apache.storm.shade.org.json.simple.JSONValue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class KafkaTridentSpoutBatchMetadataTest {
    @Test
    public void testMetadataIsRoundTripSerializableWithJsonSimple() throws Exception {
        TopicPartition tp = new TopicPartition("topic", 0);
        long startOffset = 10L;
        long endOffset = 20L;
        KafkaTridentSpoutBatchMetadata metadata = new KafkaTridentSpoutBatchMetadata(tp, startOffset, endOffset);
        Map map = metadata.toMap();
        Map deserializedMap = (Map)JSONValue.parseWithException((String)JSONValue.toJSONString((Object)map));
        KafkaTridentSpoutBatchMetadata deserializedMetadata = KafkaTridentSpoutBatchMetadata.fromMap((Map)deserializedMap);
        Assert.assertThat((Object)deserializedMetadata.getTopicPartition(), (Matcher)CoreMatchers.is((Object)metadata.getTopicPartition()));
        Assert.assertThat((Object)deserializedMetadata.getFirstOffset(), (Matcher)CoreMatchers.is((Object)metadata.getFirstOffset()));
        Assert.assertThat((Object)deserializedMetadata.getLastOffset(), (Matcher)CoreMatchers.is((Object)metadata.getLastOffset()));
    }

    @Test
    public void testCreateMetadataFromRecords() {
        TopicPartition tp = new TopicPartition("topic", 0);
        long firstOffset = 15L;
        long lastOffset = 55L;
        ConsumerRecords records = new ConsumerRecords(Collections.singletonMap(tp, SpoutWithMockedConsumerSetupHelper.createRecords(tp, firstOffset, (int)(lastOffset - firstOffset + 1L))));
        KafkaTridentSpoutBatchMetadata metadata = new KafkaTridentSpoutBatchMetadata(tp, records);
        Assert.assertThat((String)"The first offset should be the first offset in the record set", (Object)metadata.getFirstOffset(), (Matcher)CoreMatchers.is((Object)firstOffset));
        Assert.assertThat((String)"The last offset should be the last offset in the record set", (Object)metadata.getLastOffset(), (Matcher)CoreMatchers.is((Object)lastOffset));
    }
}

