/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout.test;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.kafka.spout.Func;
import org.apache.storm.kafka.spout.KafkaSpout;
import org.apache.storm.kafka.spout.KafkaSpoutConfig;
import org.apache.storm.kafka.spout.test.KafkaSpoutTestBolt;
import org.apache.storm.kafka.spout.test.KafkaSpoutTopologyMainNamedTopics;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.topology.TopologyBuilder;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;

public class KafkaSpoutTopologyMainWildcardTopics
extends KafkaSpoutTopologyMainNamedTopics {
    private static final String STREAM = "test_wildcard_stream";
    private static final Pattern TOPIC_WILDCARD_PATTERN = Pattern.compile("test[1|2]");
    public static Func<ConsumerRecord<String, String>, List<Object>> TOPIC_PART_OFF_KEY_VALUE_FUNC = new Func<ConsumerRecord<String, String>, List<Object>>(){

        public List<Object> apply(ConsumerRecord<String, String> r) {
            return new Values(new Object[]{r.topic(), r.partition(), r.offset(), r.key(), r.value()});
        }
    };

    public static void main(String[] args) throws Exception {
        new KafkaSpoutTopologyMainWildcardTopics().runMain(args);
    }

    @Override
    protected StormTopology getTopologyKafkaSpout() {
        TopologyBuilder tp = new TopologyBuilder();
        tp.setSpout("kafka_spout", (IRichSpout)new KafkaSpout(this.getKafkaSpoutConfig()), (Number)1);
        tp.setBolt("kafka_bolt", (IRichBolt)new KafkaSpoutTestBolt()).shuffleGrouping("kafka_spout", STREAM);
        return tp.createTopology();
    }

    @Override
    protected KafkaSpoutConfig<String, String> getKafkaSpoutConfig() {
        return KafkaSpoutConfig.builder((String)"127.0.0.1:9092", (Pattern)TOPIC_WILDCARD_PATTERN).setProp("group.id", (Object)"kafkaSpoutTestGroup").setRetry(this.getRetryService()).setRecordTranslator(TOPIC_PART_OFF_KEY_VALUE_FUNC, new Fields(new String[]{"topic", "partition", "offset", "key", "value"}), STREAM).setOffsetCommitPeriodMs(10000L).setFirstPollOffsetStrategy(KafkaSpoutConfig.FirstPollOffsetStrategy.EARLIEST).setMaxUncommittedOffsets(250).build();
    }
}

