/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.storm.Config;
import org.apache.storm.LocalCluster;
import org.apache.storm.StormSubmitter;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.kafka.spout.ByTopicRecordTranslator;
import org.apache.storm.kafka.spout.Func;
import org.apache.storm.kafka.spout.KafkaSpout;
import org.apache.storm.kafka.spout.KafkaSpoutConfig;
import org.apache.storm.kafka.spout.KafkaSpoutRetryExponentialBackoff;
import org.apache.storm.kafka.spout.KafkaSpoutRetryService;
import org.apache.storm.kafka.spout.RecordTranslator;
import org.apache.storm.kafka.spout.test.KafkaSpoutTestBolt;
import org.apache.storm.topology.BoltDeclarer;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.topology.TopologyBuilder;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;

public class KafkaSpoutTopologyMainNamedTopics {
    private static final String TOPIC_2_STREAM = "test_2_stream";
    private static final String TOPIC_0_1_STREAM = "test_0_1_stream";
    private static final String[] TOPICS = new String[]{"test", "test1", "test2"};
    public static Func<ConsumerRecord<String, String>, List<Object>> TOPIC_PART_OFF_KEY_VALUE_FUNC = new Func<ConsumerRecord<String, String>, List<Object>>(){

        public List<Object> apply(ConsumerRecord<String, String> r) {
            return new Values(new Object[]{r.topic(), r.partition(), r.offset(), r.key(), r.value()});
        }
    };

    public static void main(String[] args) throws Exception {
        new KafkaSpoutTopologyMainNamedTopics().runMain(args);
    }

    protected void runMain(String[] args) throws Exception {
        if (args.length == 0) {
            this.submitTopologyLocalCluster(this.getTopologyKafkaSpout(), this.getConfig());
        } else {
            this.submitTopologyRemoteCluster(args[0], this.getTopologyKafkaSpout(), this.getConfig());
        }
    }

    protected void submitTopologyLocalCluster(StormTopology topology, Config config) throws InterruptedException {
        LocalCluster cluster = new LocalCluster();
        cluster.submitTopology("test", (Map)config, topology);
        this.stopWaitingForInput();
    }

    protected void submitTopologyRemoteCluster(String arg, StormTopology topology, Config config) throws Exception {
        StormSubmitter.submitTopology((String)arg, (Map)config, (StormTopology)topology);
    }

    protected void stopWaitingForInput() {
        try {
            System.out.println("PRESS ENTER TO STOP");
            new BufferedReader(new InputStreamReader(System.in)).readLine();
            System.exit(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected Config getConfig() {
        Config config = new Config();
        config.setDebug(true);
        return config;
    }

    protected StormTopology getTopologyKafkaSpout() {
        TopologyBuilder tp = new TopologyBuilder();
        tp.setSpout("kafka_spout", (IRichSpout)new KafkaSpout(this.getKafkaSpoutConfig()), (Number)1);
        ((BoltDeclarer)tp.setBolt("kafka_bolt", (IRichBolt)new KafkaSpoutTestBolt()).shuffleGrouping("kafka_spout", TOPIC_0_1_STREAM)).shuffleGrouping("kafka_spout", TOPIC_2_STREAM);
        tp.setBolt("kafka_bolt_1", (IRichBolt)new KafkaSpoutTestBolt()).shuffleGrouping("kafka_spout", TOPIC_2_STREAM);
        return tp.createTopology();
    }

    protected KafkaSpoutConfig<String, String> getKafkaSpoutConfig() {
        ByTopicRecordTranslator trans = new ByTopicRecordTranslator(TOPIC_PART_OFF_KEY_VALUE_FUNC, new Fields(new String[]{"topic", "partition", "offset", "key", "value"}), TOPIC_0_1_STREAM);
        trans.forTopic(TOPICS[2], TOPIC_PART_OFF_KEY_VALUE_FUNC, new Fields(new String[]{"topic", "partition", "offset", "key", "value"}), TOPIC_2_STREAM);
        return KafkaSpoutConfig.builder((String)"127.0.0.1:9092", (String[])TOPICS).setProp("group.id", (Object)"kafkaSpoutTestGroup").setRetry(this.getRetryService()).setRecordTranslator((RecordTranslator)trans).setOffsetCommitPeriodMs(10000L).setFirstPollOffsetStrategy(KafkaSpoutConfig.FirstPollOffsetStrategy.EARLIEST).setMaxUncommittedOffsets(250).build();
    }

    protected KafkaSpoutRetryService getRetryService() {
        return new KafkaSpoutRetryExponentialBackoff(KafkaSpoutRetryExponentialBackoff.TimeInterval.microSeconds((long)500L), KafkaSpoutRetryExponentialBackoff.TimeInterval.milliSeconds((long)2L), Integer.MAX_VALUE, KafkaSpoutRetryExponentialBackoff.TimeInterval.seconds((long)10L));
    }
}

