/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout.subscription;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.storm.kafka.spout.ManualPartitionSubscription;
import org.apache.storm.kafka.spout.ManualPartitioner;
import org.apache.storm.kafka.spout.TopicFilter;
import org.apache.storm.task.TopologyContext;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class ManualPartitionSubscriptionTest {
    @Test
    public void testCanReassignPartitions() {
        ManualPartitioner partitionerMock = (ManualPartitioner)Mockito.mock(ManualPartitioner.class);
        TopicFilter filterMock = (TopicFilter)Mockito.mock(TopicFilter.class);
        KafkaConsumer consumerMock = (KafkaConsumer)Mockito.mock(KafkaConsumer.class);
        ConsumerRebalanceListener listenerMock = (ConsumerRebalanceListener)Mockito.mock(ConsumerRebalanceListener.class);
        TopologyContext contextMock = (TopologyContext)Mockito.mock(TopologyContext.class);
        ManualPartitionSubscription subscription = new ManualPartitionSubscription(partitionerMock, filterMock);
        List<TopicPartition> onePartition = Collections.singletonList(new TopicPartition("test", 0));
        ArrayList<TopicPartition> twoPartitions = new ArrayList<TopicPartition>();
        twoPartitions.add(new TopicPartition("test", 0));
        twoPartitions.add(new TopicPartition("test", 1));
        Mockito.when((Object)partitionerMock.partition(Matchers.anyList(), (TopologyContext)Matchers.any(TopologyContext.class))).thenReturn(onePartition).thenReturn(twoPartitions);
        subscription.subscribe(consumerMock, listenerMock, contextMock);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{consumerMock, listenerMock});
        ((KafkaConsumer)inOrder.verify((Object)consumerMock)).assign(new HashSet<TopicPartition>(onePartition));
        ((ConsumerRebalanceListener)inOrder.verify((Object)listenerMock)).onPartitionsAssigned(new HashSet<TopicPartition>(onePartition));
        Mockito.reset((Object[])new Object[]{consumerMock, listenerMock});
        Mockito.when((Object)consumerMock.assignment()).thenReturn(new HashSet<TopicPartition>(onePartition));
        subscription.refreshAssignment();
        ((ConsumerRebalanceListener)inOrder.verify((Object)listenerMock)).onPartitionsRevoked(new HashSet<TopicPartition>(onePartition));
        ((KafkaConsumer)inOrder.verify((Object)consumerMock)).assign(new HashSet(twoPartitions));
        ((ConsumerRebalanceListener)inOrder.verify((Object)listenerMock)).onPartitionsAssigned(new HashSet(twoPartitions));
    }
}

