/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout.internal;

import java.util.NoSuchElementException;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.storm.kafka.spout.KafkaSpoutMessageId;
import org.apache.storm.kafka.spout.internal.OffsetManager;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class OffsetManagerTest {
    private static final String COMMIT_METADATA = "{\"topologyId\":\"tp1\",\"taskId\":3,\"threadName\":\"Thread-20\"}";
    @Rule
    public ExpectedException expect = ExpectedException.none();
    private final long initialFetchOffset = 0L;
    private final TopicPartition testTp = new TopicPartition("testTopic", 0);
    private final OffsetManager manager = new OffsetManager(this.testTp, 0L);

    @Test
    public void testSkipMissingOffsetsWhenFindingNextCommitOffsetWithGapInMiddleOfAcked() {
        this.manager.addToEmitMsgs(0L);
        this.manager.addToEmitMsgs(1L);
        this.manager.addToEmitMsgs(2L);
        this.manager.addToEmitMsgs(5L);
        this.manager.addToEmitMsgs(6L);
        this.manager.addToAckMsgs(this.getMessageId(0L));
        this.manager.addToAckMsgs(this.getMessageId(1L));
        this.manager.addToAckMsgs(this.getMessageId(2L));
        this.manager.addToAckMsgs(this.getMessageId(6L));
        Assert.assertThat((String)"The offset manager should not skip past offset 5 which is still pending", (Object)this.manager.findNextCommitOffset(COMMIT_METADATA).offset(), (Matcher)CoreMatchers.is((Object)3L));
        this.manager.addToAckMsgs(this.getMessageId(5L));
        Assert.assertThat((String)"The offset manager should skip past the gap in acked messages, since the messages were not emitted", (Object)this.manager.findNextCommitOffset(COMMIT_METADATA), (Matcher)CoreMatchers.is((Object)new OffsetAndMetadata(7L, COMMIT_METADATA)));
    }

    @Test
    public void testSkipMissingOffsetsWhenFindingNextCommitOffsetWithGapBeforeAcked() {
        this.manager.addToEmitMsgs(5L);
        this.manager.addToEmitMsgs(6L);
        this.manager.addToAckMsgs(this.getMessageId(6L));
        Assert.assertThat((String)"The offset manager should not skip past offset 5 which is still pending", (Object)this.manager.findNextCommitOffset(COMMIT_METADATA), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        this.manager.addToAckMsgs(this.getMessageId(5L));
        Assert.assertThat((String)"The offset manager should skip past the gap in acked messages, since the messages were not emitted", (Object)this.manager.findNextCommitOffset(COMMIT_METADATA), (Matcher)CoreMatchers.is((Object)new OffsetAndMetadata(7L, COMMIT_METADATA)));
    }

    @Test
    public void testFindNextCommittedOffsetWithNoAcks() {
        OffsetAndMetadata nextCommitOffset = this.manager.findNextCommitOffset(COMMIT_METADATA);
        Assert.assertThat((String)"There shouldn't be a next commit offset when nothing has been acked", (Object)nextCommitOffset, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testFindNextCommitOffsetWithOneAck() {
        this.emitAndAckMessage(this.getMessageId(0L));
        OffsetAndMetadata nextCommitOffset = this.manager.findNextCommitOffset(COMMIT_METADATA);
        Assert.assertThat((String)"The next commit offset should be one past the processed message offset", (Object)nextCommitOffset.offset(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testFindNextCommitOffsetWithMultipleOutOfOrderAcks() {
        this.emitAndAckMessage(this.getMessageId(1L));
        this.emitAndAckMessage(this.getMessageId(0L));
        OffsetAndMetadata nextCommitOffset = this.manager.findNextCommitOffset(COMMIT_METADATA);
        Assert.assertThat((String)"The next commit offset should be one past the processed message offset", (Object)nextCommitOffset.offset(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void testFindNextCommitOffsetWithAckedOffsetGap() {
        this.emitAndAckMessage(this.getMessageId(2L));
        this.manager.addToEmitMsgs(1L);
        this.emitAndAckMessage(this.getMessageId(0L));
        OffsetAndMetadata nextCommitOffset = this.manager.findNextCommitOffset(COMMIT_METADATA);
        Assert.assertThat((String)"The next commit offset should cover the sequential acked offsets", (Object)nextCommitOffset.offset(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testFindNextOffsetWithAckedButNotEmittedOffsetGap() {
        this.emitAndAckMessage(this.getMessageId(2L));
        this.emitAndAckMessage(this.getMessageId(0L));
        OffsetAndMetadata nextCommitOffset = this.manager.findNextCommitOffset(COMMIT_METADATA);
        Assert.assertThat((String)"The next commit offset should cover all the acked offsets, since the offset in the gap hasn't been emitted and doesn't exist", (Object)nextCommitOffset.offset(), (Matcher)CoreMatchers.is((Object)3L));
    }

    @Test
    public void testFindNextCommitOffsetWithUnackedOffsetGap() {
        this.manager.addToEmitMsgs(1L);
        this.emitAndAckMessage(this.getMessageId(0L));
        OffsetAndMetadata nextCommitOffset = this.manager.findNextCommitOffset(COMMIT_METADATA);
        Assert.assertThat((String)"The next commit offset should cover the contiguously acked offsets", (Object)nextCommitOffset.offset(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testFindNextCommitOffsetWhenTooLowOffsetIsAcked() {
        OffsetManager startAtHighOffsetManager = new OffsetManager(this.testTp, 10L);
        this.emitAndAckMessage(this.getMessageId(0L));
        OffsetAndMetadata nextCommitOffset = startAtHighOffsetManager.findNextCommitOffset(COMMIT_METADATA);
        Assert.assertThat((String)"Acking an offset earlier than the committed offset should have no effect", (Object)nextCommitOffset, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testCommit() {
        this.emitAndAckMessage(this.getMessageId(0L));
        this.emitAndAckMessage(this.getMessageId(1L));
        this.emitAndAckMessage(this.getMessageId(2L));
        long committedMessages = this.manager.commit(new OffsetAndMetadata(2L));
        Assert.assertThat((String)"Should have committed all messages to the left of the earliest uncommitted offset", (Object)committedMessages, (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((String)"The committed messages should not be in the acked list anymore", (Object)this.manager.contains(this.getMessageId(0L)), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((String)"The committed messages should not be in the emitted list anymore", (Object)this.manager.containsEmitted(0L), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((String)"The committed messages should not be in the acked list anymore", (Object)this.manager.contains(this.getMessageId(1L)), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((String)"The committed messages should not be in the emitted list anymore", (Object)this.manager.containsEmitted(1L), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((String)"The uncommitted message should still be in the acked list", (Object)this.manager.contains(this.getMessageId(2L)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)"The uncommitted message should still be in the emitted list", (Object)this.manager.containsEmitted(2L), (Matcher)CoreMatchers.is((Object)true));
    }

    private KafkaSpoutMessageId getMessageId(long offset) {
        return new KafkaSpoutMessageId(this.testTp, offset);
    }

    private void emitAndAckMessage(KafkaSpoutMessageId msgId) {
        this.manager.addToEmitMsgs(msgId.offset());
        this.manager.addToAckMsgs(msgId);
    }

    @Test
    public void testGetNthUncommittedOffsetAfterCommittedOffset() {
        this.manager.addToEmitMsgs(1L);
        this.manager.addToEmitMsgs(2L);
        this.manager.addToEmitMsgs(5L);
        this.manager.addToEmitMsgs(30L);
        Assert.assertThat((String)"The third uncommitted offset should be 5", (Object)this.manager.getNthUncommittedOffsetAfterCommittedOffset(3), (Matcher)CoreMatchers.is((Object)5L));
        Assert.assertThat((String)"The fourth uncommitted offset should be 30", (Object)this.manager.getNthUncommittedOffsetAfterCommittedOffset(4), (Matcher)CoreMatchers.is((Object)30L));
        this.expect.expect(NoSuchElementException.class);
        this.manager.getNthUncommittedOffsetAfterCommittedOffset(5);
    }

    @Test
    public void testCommittedFlagSetOnCommit() throws Exception {
        Assert.assertFalse((boolean)this.manager.hasCommitted());
        this.manager.commit((OffsetAndMetadata)Mockito.mock(OffsetAndMetadata.class));
        Assert.assertTrue((boolean)this.manager.hasCommitted());
    }
}

