/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout.builders;

import java.util.List;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.storm.Config;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.kafka.spout.Func;
import org.apache.storm.kafka.spout.KafkaSpout;
import org.apache.storm.kafka.spout.KafkaSpoutConfig;
import org.apache.storm.kafka.spout.KafkaSpoutRetryExponentialBackoff;
import org.apache.storm.kafka.spout.KafkaSpoutRetryService;
import org.apache.storm.kafka.spout.Subscription;
import org.apache.storm.kafka.spout.test.KafkaSpoutTestBolt;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.topology.TopologyBuilder;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;

public class SingleTopicKafkaSpoutConfiguration {
    public static final String STREAM = "test_stream";
    public static final String TOPIC = "test";
    private static Func<ConsumerRecord<String, String>, List<Object>> TOPIC_KEY_VALUE_FUNC = new Func<ConsumerRecord<String, String>, List<Object>>(){

        public List<Object> apply(ConsumerRecord<String, String> r) {
            return new Values(new Object[]{r.topic(), r.key(), r.value()});
        }
    };

    public static Config getConfig() {
        Config config = new Config();
        config.setDebug(true);
        return config;
    }

    public static StormTopology getTopologyKafkaSpout(int port) {
        TopologyBuilder tp = new TopologyBuilder();
        tp.setSpout("kafka_spout", (IRichSpout)new KafkaSpout(SingleTopicKafkaSpoutConfiguration.createKafkaSpoutConfigBuilder(port).build()), (Number)1);
        tp.setBolt("kafka_bolt", (IRichBolt)new KafkaSpoutTestBolt()).shuffleGrouping("kafka_spout", STREAM);
        return tp.createTopology();
    }

    public static KafkaSpoutConfig.Builder<String, String> createKafkaSpoutConfigBuilder(int port) {
        return SingleTopicKafkaSpoutConfiguration.setCommonSpoutConfig((KafkaSpoutConfig.Builder<String, String>)KafkaSpoutConfig.builder((String)("127.0.0.1:" + port), (String[])new String[]{TOPIC}));
    }

    public static KafkaSpoutConfig.Builder<String, String> createKafkaSpoutConfigBuilder(Subscription subscription, int port) {
        return SingleTopicKafkaSpoutConfiguration.setCommonSpoutConfig((KafkaSpoutConfig.Builder<String, String>)new KafkaSpoutConfig.Builder("127.0.0.1:" + port, subscription));
    }

    public static KafkaSpoutConfig.Builder<String, String> setCommonSpoutConfig(KafkaSpoutConfig.Builder<String, String> config) {
        return config.setRecordTranslator(TOPIC_KEY_VALUE_FUNC, new Fields(new String[]{"topic", "key", "value"}), STREAM).setProp("group.id", (Object)"kafkaSpoutTestGroup").setProp("max.poll.records", (Object)5).setRetry(SingleTopicKafkaSpoutConfiguration.getNoDelayRetryService()).setOffsetCommitPeriodMs(10000L).setFirstPollOffsetStrategy(KafkaSpoutConfig.FirstPollOffsetStrategy.EARLIEST).setMaxUncommittedOffsets(250).setPollTimeoutMs(1000L);
    }

    protected static KafkaSpoutRetryService getNoDelayRetryService() {
        return new KafkaSpoutRetryExponentialBackoff(KafkaSpoutRetryExponentialBackoff.TimeInterval.seconds((long)0L), KafkaSpoutRetryExponentialBackoff.TimeInterval.milliSeconds((long)0L), Integer.MAX_VALUE, KafkaSpoutRetryExponentialBackoff.TimeInterval.milliSeconds((long)0L));
    }
}

