/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.storm.kafka.spout.KafkaSpout;
import org.apache.storm.kafka.spout.KafkaSpoutConfig;
import org.apache.storm.kafka.spout.KafkaSpoutMessageId;
import org.apache.storm.kafka.spout.Subscription;
import org.apache.storm.kafka.spout.internal.KafkaConsumerFactory;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class SpoutWithMockedConsumerSetupHelper {
    public static <K, V> KafkaSpout<K, V> setupSpout(KafkaSpoutConfig<K, V> spoutConfig, Map<String, Object> topoConf, TopologyContext contextMock, SpoutOutputCollector collectorMock, final KafkaConsumer<K, V> consumerMock, TopicPartition ... assignedPartitions) {
        Subscription subscriptionMock = spoutConfig.getSubscription();
        if (!Mockito.mockingDetails((Object)subscriptionMock).isMock()) {
            throw new IllegalStateException("Use a mocked subscription when using this method, it helps avoid complex stubbing");
        }
        final HashSet<TopicPartition> assignedPartitionsSet = new HashSet<TopicPartition>(Arrays.asList(assignedPartitions));
        Mockito.when((Object)consumerMock.assignment()).thenReturn(assignedPartitionsSet);
        ((Subscription)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ConsumerRebalanceListener listener = (ConsumerRebalanceListener)invocation.getArguments()[1];
                listener.onPartitionsAssigned((Collection)assignedPartitionsSet);
                return null;
            }
        }).when((Object)subscriptionMock)).subscribe((KafkaConsumer)Matchers.any(KafkaConsumer.class), (ConsumerRebalanceListener)Matchers.any(ConsumerRebalanceListener.class), (TopologyContext)Matchers.any(TopologyContext.class));
        KafkaConsumerFactory consumerFactory = new KafkaConsumerFactory<K, V>(){

            public KafkaConsumer<K, V> createConsumer(KafkaSpoutConfig<K, V> kafkaSpoutConfig) {
                return consumerMock;
            }
        };
        KafkaSpout spout = new KafkaSpout(spoutConfig, consumerFactory);
        spout.open(topoConf, contextMock, collectorMock);
        spout.activate();
        return spout;
    }

    public static <K, V> List<ConsumerRecord<K, V>> createRecords(TopicPartition topic, long startingOffset, int numRecords) {
        ArrayList<ConsumerRecord<K, V>> recordsForPartition = new ArrayList<ConsumerRecord<K, V>>();
        for (int i = 0; i < numRecords; ++i) {
            recordsForPartition.add(new ConsumerRecord(topic.topic(), topic.partition(), startingOffset + (long)i, null, null));
        }
        return recordsForPartition;
    }

    public static <K, V> List<KafkaSpoutMessageId> pollAndEmit(KafkaSpout<K, V> spout, KafkaConsumer<K, V> consumerMock, int expectedEmits, SpoutOutputCollector collectorMock, TopicPartition partition, int ... offsetsToEmit) {
        return SpoutWithMockedConsumerSetupHelper.pollAndEmit(spout, consumerMock, expectedEmits, collectorMock, Collections.singletonMap(partition, offsetsToEmit));
    }

    public static <K, V> List<KafkaSpoutMessageId> pollAndEmit(KafkaSpout<K, V> spout, KafkaConsumer<K, V> consumerMock, int expectedEmits, SpoutOutputCollector collectorMock, Map<TopicPartition, int[]> offsetsToEmit) {
        int totalOffsets = 0;
        HashMap records = new HashMap();
        for (Map.Entry<TopicPartition, int[]> entry : offsetsToEmit.entrySet()) {
            TopicPartition tp = entry.getKey();
            ArrayList<ConsumerRecord> tpRecords = new ArrayList<ConsumerRecord>();
            int[] nArray = entry.getValue();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer offset = nArray[i];
                tpRecords.add(new ConsumerRecord(tp.topic(), tp.partition(), (long)offset.intValue(), null, null));
                ++totalOffsets;
            }
            records.put(tp, tpRecords);
        }
        Mockito.when((Object)consumerMock.poll(Matchers.anyLong())).thenReturn((Object)new ConsumerRecords(records));
        for (int i = 0; i < totalOffsets; ++i) {
            spout.nextTuple();
        }
        ArgumentCaptor messageIds = ArgumentCaptor.forClass(KafkaSpoutMessageId.class);
        ((SpoutOutputCollector)Mockito.verify((Object)collectorMock, (VerificationMode)Mockito.times((int)expectedEmits))).emit(Matchers.anyString(), Matchers.anyList(), messageIds.capture());
        return messageIds.getAllValues();
    }
}

