/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.storm.kafka.KafkaUnit;
import org.apache.storm.kafka.spout.KafkaSpout;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SingleTopicKafkaUnitSetupHelper {
    public static void populateTopicData(KafkaUnit kafkaUnit, String topicName, int msgCount) throws Exception {
        kafkaUnit.createTopic(topicName);
        for (int i = 0; i < msgCount; ++i) {
            ProducerRecord producerRecord = new ProducerRecord(topicName, (Object)Integer.toString(i), (Object)Integer.toString(i));
            kafkaUnit.sendMessage(producerRecord);
        }
    }

    public static <K, V> void verifyAllMessagesCommitted(KafkaConsumer<K, V> consumerSpy, ArgumentCaptor<Map<TopicPartition, OffsetAndMetadata>> commitCapture, long messageCount) {
        ((KafkaConsumer)Mockito.verify(consumerSpy, (VerificationMode)Mockito.times((int)1))).commitSync((Map)commitCapture.capture());
        Map commits = (Map)commitCapture.getValue();
        MatcherAssert.assertThat((String)"Expected commits for only one topic partition", (Object)commits.entrySet().size(), (Matcher)CoreMatchers.is((Object)1));
        OffsetAndMetadata offset = (OffsetAndMetadata)commits.entrySet().iterator().next().getValue();
        MatcherAssert.assertThat((String)"Expected committed offset to cover all emitted messages", (Object)offset.offset(), (Matcher)CoreMatchers.is((Object)messageCount));
    }

    public static <K, V> void initializeSpout(KafkaSpout<K, V> spout, Map<String, Object> topoConf, TopologyContext topoContextMock, SpoutOutputCollector collectorMock) throws Exception {
        Mockito.when((Object)topoContextMock.getThisTaskIndex()).thenReturn((Object)0);
        Mockito.when((Object)topoContextMock.getComponentTasks(Matchers.anyString())).thenReturn(Collections.singletonList(0));
        spout.open(topoConf, topoContextMock, collectorMock);
        spout.activate();
    }
}

