/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.storm.kafka.spout.PatternTopicFilter;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class PatternTopicFilterTest {
    private KafkaConsumer<?, ?> consumerMock;

    @Before
    public void setUp() {
        this.consumerMock = (KafkaConsumer)Mockito.mock(KafkaConsumer.class);
    }

    @Test
    public void testFilter() {
        Pattern pattern = Pattern.compile("test-\\d+");
        PatternTopicFilter filter = new PatternTopicFilter(pattern);
        String matchingTopicOne = "test-1";
        String matchingTopicTwo = "test-11";
        String unmatchedTopic = "unmatched";
        HashMap<String, List<Object>> allTopics = new HashMap<String, List<Object>>();
        allTopics.put(matchingTopicOne, Collections.singletonList(this.createPartitionInfo(matchingTopicOne, 0)));
        ArrayList<PartitionInfo> testTwoPartitions = new ArrayList<PartitionInfo>();
        testTwoPartitions.add(this.createPartitionInfo(matchingTopicTwo, 0));
        testTwoPartitions.add(this.createPartitionInfo(matchingTopicTwo, 1));
        allTopics.put(matchingTopicTwo, testTwoPartitions);
        allTopics.put(unmatchedTopic, Collections.singletonList(this.createPartitionInfo(unmatchedTopic, 0)));
        Mockito.when((Object)this.consumerMock.listTopics()).thenReturn(allTopics);
        List matchedPartitions = filter.getFilteredTopicPartitions(this.consumerMock);
        Assert.assertThat((String)"Expected topic partitions matching the pattern to be passed by the filter", (Object)matchedPartitions, (Matcher)Matchers.containsInAnyOrder((Object[])new TopicPartition[]{new TopicPartition(matchingTopicOne, 0), new TopicPartition(matchingTopicTwo, 0), new TopicPartition(matchingTopicTwo, 1)}));
    }

    private PartitionInfo createPartitionInfo(String topic, int partition) {
        return new PartitionInfo(topic, partition, null, null, null);
    }
}

