/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.storm.kafka.spout.NamedTopicFilter;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class NamedTopicFilterTest {
    private KafkaConsumer<?, ?> consumerMock;

    @Before
    public void setUp() {
        this.consumerMock = (KafkaConsumer)Mockito.mock(KafkaConsumer.class);
    }

    @Test
    public void testFilter() {
        String matchingTopicOne = "test-1";
        String matchingTopicTwo = "test-11";
        String unmatchedTopic = "unmatched";
        NamedTopicFilter filter = new NamedTopicFilter(new String[]{matchingTopicOne, matchingTopicTwo});
        Mockito.when((Object)this.consumerMock.partitionsFor(matchingTopicOne)).thenReturn(Collections.singletonList(this.createPartitionInfo(matchingTopicOne, 0)));
        ArrayList<PartitionInfo> partitionTwoPartitions = new ArrayList<PartitionInfo>();
        partitionTwoPartitions.add(this.createPartitionInfo(matchingTopicTwo, 0));
        partitionTwoPartitions.add(this.createPartitionInfo(matchingTopicTwo, 1));
        Mockito.when((Object)this.consumerMock.partitionsFor(matchingTopicTwo)).thenReturn(partitionTwoPartitions);
        Mockito.when((Object)this.consumerMock.partitionsFor(unmatchedTopic)).thenReturn(Collections.singletonList(this.createPartitionInfo(unmatchedTopic, 0)));
        List matchedPartitions = filter.getFilteredTopicPartitions(this.consumerMock);
        Assert.assertThat((String)"Expected filter to pass only topics with exact name matches", (Object)matchedPartitions, (Matcher)Matchers.containsInAnyOrder((Object[])new TopicPartition[]{new TopicPartition(matchingTopicOne, 0), new TopicPartition(matchingTopicTwo, 0), new TopicPartition(matchingTopicTwo, 1)}));
    }

    private PartitionInfo createPartitionInfo(String topic, int partition) {
        return new PartitionInfo(topic, partition, null, null, null);
    }
}

