/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.kafka.KafkaUnitRule;
import org.apache.storm.kafka.spout.KafkaSpout;
import org.apache.storm.kafka.spout.KafkaSpoutConfig;
import org.apache.storm.kafka.spout.KafkaSpoutMessageId;
import org.apache.storm.kafka.spout.KafkaSpoutRetryExponentialBackoff;
import org.apache.storm.kafka.spout.KafkaSpoutRetryService;
import org.apache.storm.kafka.spout.SingleTopicKafkaUnitSetupHelper;
import org.apache.storm.kafka.spout.builders.SingleTopicKafkaSpoutConfiguration;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.utils.Time;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class MaxUncommittedOffsetTest {
    @Rule
    public KafkaUnitRule kafkaUnitRule = new KafkaUnitRule();
    private final TopologyContext topologyContext = (TopologyContext)Mockito.mock(TopologyContext.class);
    private final Map<String, Object> conf = new HashMap<String, Object>();
    private final SpoutOutputCollector collector = (SpoutOutputCollector)Mockito.mock(SpoutOutputCollector.class);
    private final long commitOffsetPeriodMs = 2000L;
    private final int numMessages = 100;
    private final int maxUncommittedOffsets = 10;
    private final int maxPollRecords = 5;
    private final int initialRetryDelaySecs = 60;
    private final KafkaSpoutConfig<String, String> spoutConfig = SingleTopicKafkaSpoutConfiguration.createKafkaSpoutConfigBuilder(this.kafkaUnitRule.getKafkaUnit().getKafkaPort()).setOffsetCommitPeriodMs(2000L).setProp("max.poll.records", (Object)5).setMaxUncommittedOffsets(10).setRetry((KafkaSpoutRetryService)new KafkaSpoutRetryExponentialBackoff(KafkaSpoutRetryExponentialBackoff.TimeInterval.seconds((long)60L), KafkaSpoutRetryExponentialBackoff.TimeInterval.seconds((long)0L), 1, KafkaSpoutRetryExponentialBackoff.TimeInterval.seconds((long)60L))).build();
    private KafkaSpout<String, String> spout;

    @Before
    public void setUp() {
        Assert.assertThat((String)"Current tests require numMessages >= 2*maxUncommittedOffsets", (Object)100, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(20)));
        Assert.assertThat((String)"Current tests require maxPollRecords < maxUncommittedOffsets", (Object)5, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(10)));
        MockitoAnnotations.initMocks((Object)this);
        this.spout = new KafkaSpout(this.spoutConfig);
    }

    private void prepareSpout(int msgCount) throws Exception {
        SingleTopicKafkaUnitSetupHelper.populateTopicData(this.kafkaUnitRule.getKafkaUnit(), "test", msgCount);
        SingleTopicKafkaUnitSetupHelper.initializeSpout(this.spout, this.conf, this.topologyContext, this.collector);
    }

    private ArgumentCaptor<KafkaSpoutMessageId> emitMaxUncommittedOffsetsMessagesAndCheckNoMoreAreEmitted(int messageCount) throws Exception {
        Assert.assertThat((String)"The message count is less than maxUncommittedOffsets. This test is not meaningful with this configuration.", (Object)messageCount, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(10)));
        this.prepareSpout(messageCount);
        ArgumentCaptor messageIds = ArgumentCaptor.forClass(KafkaSpoutMessageId.class);
        for (int i = 0; i < messageCount; ++i) {
            this.spout.nextTuple();
        }
        ((SpoutOutputCollector)Mockito.verify((Object)this.collector, (VerificationMode)Mockito.times((int)10))).emit(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyList(), messageIds.capture());
        return messageIds;
    }

    @Test
    public void testNextTupleCanEmitMoreMessagesWhenDroppingBelowMaxUncommittedOffsetsDueToCommit() throws Exception {
        try (Time.SimulatedTime simulatedTime = new Time.SimulatedTime();){
            ArgumentCaptor<KafkaSpoutMessageId> messageIds = this.emitMaxUncommittedOffsetsMessagesAndCheckNoMoreAreEmitted(100);
            Mockito.reset((Object[])new SpoutOutputCollector[]{this.collector});
            for (KafkaSpoutMessageId messageId : messageIds.getAllValues()) {
                this.spout.ack((Object)messageId);
            }
            Time.advanceTime((long)2500L);
            this.spout.nextTuple();
            for (int i = 0; i < 100; ++i) {
                this.spout.nextTuple();
            }
            ((SpoutOutputCollector)Mockito.verify((Object)this.collector, (VerificationMode)Mockito.times((int)10))).emit(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyList(), org.mockito.Matchers.anyObject());
        }
    }

    @Test
    public void testNextTupleWillRespectMaxUncommittedOffsetsWhenThereAreAckedUncommittedTuples() throws Exception {
        try (Time.SimulatedTime simulatedTime = new Time.SimulatedTime();){
            int i;
            ArgumentCaptor<KafkaSpoutMessageId> messageIds = this.emitMaxUncommittedOffsetsMessagesAndCheckNoMoreAreEmitted(100);
            Mockito.reset((Object[])new SpoutOutputCollector[]{this.collector});
            List messageIdList = messageIds.getAllValues();
            for (i = 0; i < messageIdList.size() - 1; ++i) {
                this.spout.fail(messageIdList.get(i));
            }
            this.spout.ack(messageIdList.get(messageIdList.size() - 1));
            Time.advanceTime((long)2500L);
            this.spout.nextTuple();
            for (i = 0; i < 100; ++i) {
                this.spout.nextTuple();
            }
            ((SpoutOutputCollector)Mockito.verify((Object)this.collector, (VerificationMode)Mockito.times((int)0))).emit(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyList(), org.mockito.Matchers.anyObject());
        }
    }

    private void failAllExceptTheFirstMessageThenCommit(ArgumentCaptor<KafkaSpoutMessageId> messageIds) {
        List messageIdList = messageIds.getAllValues();
        for (int i = 1; i < messageIdList.size(); ++i) {
            this.spout.fail(messageIdList.get(i));
        }
        this.spout.ack(messageIdList.get(0));
        Time.advanceTime((long)2500L);
        this.spout.nextTuple();
    }

    @Test
    public void testNextTupleWillNotEmitMoreThanMaxUncommittedOffsetsPlusMaxPollRecordsMessages() throws Exception {
        try (Time.SimulatedTime simulatedTime = new Time.SimulatedTime();){
            ArgumentCaptor<KafkaSpoutMessageId> messageIds = this.emitMaxUncommittedOffsetsMessagesAndCheckNoMoreAreEmitted(100);
            Mockito.reset((Object[])new SpoutOutputCollector[]{this.collector});
            List messageIdList = messageIds.getAllValues();
            KafkaSpoutMessageId failedMessageId = (KafkaSpoutMessageId)messageIdList.get(messageIdList.size() - 1);
            this.spout.fail((Object)failedMessageId);
            this.spout.nextTuple();
            ((SpoutOutputCollector)Mockito.verify((Object)this.collector, (VerificationMode)Mockito.never())).emit(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyList(), org.mockito.Matchers.any(KafkaSpoutMessageId.class));
            Time.advanceTimeSecs((long)60L);
            for (int i = 0; i < 5; ++i) {
                this.spout.nextTuple();
            }
            ArgumentCaptor secondRunMessageIds = ArgumentCaptor.forClass(KafkaSpoutMessageId.class);
            ((SpoutOutputCollector)Mockito.verify((Object)this.collector, (VerificationMode)Mockito.times((int)5))).emit(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyList(), secondRunMessageIds.capture());
            Mockito.reset((Object[])new SpoutOutputCollector[]{this.collector});
            Assert.assertThat(secondRunMessageIds.getAllValues().get(0), (Matcher)CoreMatchers.is((Object)failedMessageId));
            this.spout.fail(secondRunMessageIds.getAllValues().get(secondRunMessageIds.getAllValues().size() - 1));
            Time.advanceTimeSecs((long)60L);
            this.spout.nextTuple();
            ((SpoutOutputCollector)Mockito.verify((Object)this.collector, (VerificationMode)Mockito.never())).emit(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyList(), org.mockito.Matchers.any(KafkaSpoutMessageId.class));
        }
    }

    @Test
    public void testNextTupleWillAllowRetryForTuplesBelowEmitLimit() throws Exception {
        try (Time.SimulatedTime simulatedTime = new Time.SimulatedTime();){
            ArgumentCaptor<KafkaSpoutMessageId> messageIds = this.emitMaxUncommittedOffsetsMessagesAndCheckNoMoreAreEmitted(100);
            Mockito.reset((Object[])new SpoutOutputCollector[]{this.collector});
            this.failAllExceptTheFirstMessageThenCommit(messageIds);
            for (int i = 0; i < 10; ++i) {
                this.spout.nextTuple();
            }
            ArgumentCaptor secondRunMessageIds = ArgumentCaptor.forClass(KafkaSpoutMessageId.class);
            ((SpoutOutputCollector)Mockito.verify((Object)this.collector, (VerificationMode)Mockito.times((int)5))).emit(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyList(), secondRunMessageIds.capture());
            Mockito.reset((Object[])new SpoutOutputCollector[]{this.collector});
            ArrayList<Long> firstRunOffsets = new ArrayList<Long>();
            for (Object msgId : messageIds.getAllValues()) {
                firstRunOffsets.add(msgId.offset());
            }
            ArrayList<Long> secondRunOffsets = new ArrayList<Long>();
            for (KafkaSpoutMessageId msgId : secondRunMessageIds.getAllValues()) {
                secondRunOffsets.add(msgId.offset());
            }
            Assert.assertThat((String)"Expected the newly emitted messages to have no overlap with the first batch", (Object)secondRunOffsets.removeAll(firstRunOffsets), (Matcher)CoreMatchers.is((Object)false));
            for (KafkaSpoutMessageId msgId : secondRunMessageIds.getAllValues()) {
                this.spout.fail((Object)msgId);
            }
            Time.advanceTimeSecs((long)60L);
            for (int i = 0; i < 100; ++i) {
                this.spout.nextTuple();
            }
            ArgumentCaptor thirdRunMessageIds = ArgumentCaptor.forClass(KafkaSpoutMessageId.class);
            ((SpoutOutputCollector)Mockito.verify((Object)this.collector, (VerificationMode)Mockito.times((int)10))).emit(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyList(), thirdRunMessageIds.capture());
            Mockito.reset((Object[])new SpoutOutputCollector[]{this.collector});
            ArrayList<Long> thirdRunOffsets = new ArrayList<Long>();
            for (KafkaSpoutMessageId msgId : thirdRunMessageIds.getAllValues()) {
                thirdRunOffsets.add(msgId.offset());
            }
            Assert.assertThat((String)"Expected the emitted messages to be retries of the failed tuples from the first batch, plus the first failed tuple from the second batch", thirdRunOffsets, (Matcher)CoreMatchers.everyItem((Matcher)CoreMatchers.either((Matcher)Matchers.isIn(firstRunOffsets)).or(CoreMatchers.is((Object)((KafkaSpoutMessageId)secondRunMessageIds.getAllValues().get(0)).offset()))));
        }
    }
}

