/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.util.regex.Pattern;
import org.apache.storm.kafka.spout.KafkaSpoutAbstractTest;
import org.apache.storm.kafka.spout.KafkaSpoutConfig;
import org.apache.storm.kafka.spout.SingleTopicKafkaUnitSetupHelper;
import org.apache.storm.kafka.spout.builders.SingleTopicKafkaSpoutConfiguration;
import org.junit.Test;
import org.mockito.Mockito;

public class KafkaSpoutTopologyDeployActivateDeactivateTest
extends KafkaSpoutAbstractTest {
    public KafkaSpoutTopologyDeployActivateDeactivateTest() {
        super(2000L);
    }

    @Override
    KafkaSpoutConfig<String, String> createSpoutConfig() {
        return SingleTopicKafkaSpoutConfiguration.setCommonSpoutConfig((KafkaSpoutConfig.Builder<String, String>)KafkaSpoutConfig.builder((String)("127.0.0.1:" + this.kafkaUnitRule.getKafkaUnit().getKafkaPort()), (Pattern)Pattern.compile("test"))).setOffsetCommitPeriodMs(this.commitOffsetPeriodMs).setFirstPollOffsetStrategy(KafkaSpoutConfig.FirstPollOffsetStrategy.EARLIEST).build();
    }

    @Test
    public void test_FirstPollStrategy_Earliest_NotEnforced_OnTopologyActivateDeactivate() throws Exception {
        int messageCount = 2;
        this.prepareSpout(2);
        this.nextTuple_verifyEmitted_ack_resetCollector(0);
        this.spout.deactivate();
        this.verifyAllMessagesCommitted(1L);
        this.consumerSpy = this.createConsumerSpy();
        this.spout.activate();
        this.nextTuple_verifyEmitted_ack_resetCollector(1);
        this.commitAndVerifyAllMessagesCommitted(2L);
    }

    @Test
    public void test_FirstPollStrategy_Earliest_NotEnforced_OnPartitionReassignment() throws Exception {
        Mockito.when((Object)this.topologyContext.getStormId()).thenReturn((Object)"topology-1");
        int messageCount = 2;
        this.prepareSpout(2);
        this.nextTuple_verifyEmitted_ack_resetCollector(0);
        this.spout.deactivate();
        this.verifyAllMessagesCommitted(1L);
        this.setUp();
        SingleTopicKafkaUnitSetupHelper.initializeSpout(this.spout, this.conf, this.topologyContext, this.collectorMock);
        this.nextTuple_verifyEmitted_ack_resetCollector(1);
        this.commitAndVerifyAllMessagesCommitted(2L);
    }

    @Test
    public void test_FirstPollStrategy_Earliest_Enforced_OnlyOnTopologyDeployment() throws Exception {
        Mockito.when((Object)this.topologyContext.getStormId()).thenReturn((Object)"topology-1");
        int messageCount = 2;
        this.prepareSpout(2);
        this.nextTuple_verifyEmitted_ack_resetCollector(0);
        this.spout.deactivate();
        this.verifyAllMessagesCommitted(1L);
        this.setUp();
        Mockito.when((Object)this.topologyContext.getStormId()).thenReturn((Object)"topology-2");
        SingleTopicKafkaUnitSetupHelper.initializeSpout(this.spout, this.conf, this.topologyContext, this.collectorMock);
        for (int i = 0; i < 2; ++i) {
            this.nextTuple_verifyEmitted_ack_resetCollector(i);
        }
        this.commitAndVerifyAllMessagesCommitted(2L);
    }
}

