/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.storm.kafka.spout.KafkaSpoutAbstractTest;
import org.apache.storm.kafka.spout.KafkaSpoutConfig;
import org.apache.storm.kafka.spout.KafkaSpoutMessageId;
import org.apache.storm.kafka.spout.KafkaSpoutRetryExponentialBackoff;
import org.apache.storm.kafka.spout.KafkaSpoutRetryService;
import org.apache.storm.kafka.spout.SingleTopicKafkaUnitSetupHelper;
import org.apache.storm.kafka.spout.builders.SingleTopicKafkaSpoutConfiguration;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.tuple.Values;
import org.apache.storm.utils.Time;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class KafkaSpoutSingleTopicTest
extends KafkaSpoutAbstractTest {
    private final int maxPollRecords = 10;
    private final int maxRetries = 3;

    public KafkaSpoutSingleTopicTest() {
        super(2000L);
    }

    @Override
    KafkaSpoutConfig<String, String> createSpoutConfig() {
        return SingleTopicKafkaSpoutConfiguration.setCommonSpoutConfig((KafkaSpoutConfig.Builder<String, String>)KafkaSpoutConfig.builder((String)("127.0.0.1:" + this.kafkaUnitRule.getKafkaUnit().getKafkaPort()), (Pattern)Pattern.compile("test"))).setOffsetCommitPeriodMs(this.commitOffsetPeriodMs).setRetry((KafkaSpoutRetryService)new KafkaSpoutRetryExponentialBackoff(KafkaSpoutRetryExponentialBackoff.TimeInterval.seconds((long)0L), KafkaSpoutRetryExponentialBackoff.TimeInterval.seconds((long)0L), 3, KafkaSpoutRetryExponentialBackoff.TimeInterval.seconds((long)0L))).setProp("max.poll.records", (Object)10).build();
    }

    @Test
    public void testSeekToCommittedOffsetIfConsumerPositionIsBehindWhenCommitting() throws Exception {
        int messageCount = 20;
        this.prepareSpout(20);
        for (int i = 0; i < 20; ++i) {
            this.spout.nextTuple();
        }
        ArgumentCaptor messageIdCaptor = ArgumentCaptor.forClass(KafkaSpoutMessageId.class);
        ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock, (VerificationMode)Mockito.times((int)20))).emit(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyList(), messageIdCaptor.capture());
        List messageIds = messageIdCaptor.getAllValues();
        for (int i = 1; i < messageIds.size(); ++i) {
            this.spout.ack(messageIds.get(i));
        }
        KafkaSpoutMessageId failedTuple = (KafkaSpoutMessageId)messageIds.get(0);
        this.spout.fail((Object)failedTuple);
        Mockito.reset((Object[])new SpoutOutputCollector[]{this.collectorMock});
        this.spout.nextTuple();
        ArgumentCaptor failedIdReplayCaptor = ArgumentCaptor.forClass(KafkaSpoutMessageId.class);
        ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock)).emit(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyList(), failedIdReplayCaptor.capture());
        MatcherAssert.assertThat((String)"Expected replay of failed tuple", (Object)failedIdReplayCaptor.getValue(), (Matcher)CoreMatchers.is((Object)failedTuple));
        Mockito.reset((Object[])new SpoutOutputCollector[]{this.collectorMock});
        Time.advanceTime((long)(500L + this.commitOffsetPeriodMs));
        this.spout.ack(failedIdReplayCaptor.getValue());
        this.spout.nextTuple();
        ((KafkaConsumer)Mockito.verify((Object)this.consumerSpy)).commitSync((Map)this.commitCapture.capture());
        Map capturedCommit = (Map)this.commitCapture.getValue();
        TopicPartition expectedTp = new TopicPartition("test", 0);
        MatcherAssert.assertThat((String)"Should have committed to the right topic", (Object)capturedCommit, (Matcher)Matchers.hasKey((Object)expectedTp));
        MatcherAssert.assertThat((String)"Should have committed all the acked messages", (Object)((OffsetAndMetadata)capturedCommit.get(expectedTp)).offset(), (Matcher)CoreMatchers.is((Object)20L));
        for (int i = 0; i < 3; ++i) {
            this.spout.nextTuple();
        }
        ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock, (VerificationMode)Mockito.never())).emit(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyList(), org.mockito.Matchers.anyObject());
    }

    @Test
    public void testShouldContinueWithSlowDoubleAcks() throws Exception {
        int i;
        int messageCount = 20;
        this.prepareSpout(20);
        ArgumentCaptor messageIdToDoubleAck = ArgumentCaptor.forClass(Object.class);
        this.spout.nextTuple();
        ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock)).emit(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyList(), messageIdToDoubleAck.capture());
        this.spout.ack(messageIdToDoubleAck.getValue());
        for (i = 0; i < 10; ++i) {
            this.spout.nextTuple();
        }
        this.spout.ack(messageIdToDoubleAck.getValue());
        for (i = 0; i < 20; ++i) {
            this.spout.nextTuple();
        }
        ArgumentCaptor messageIds = ArgumentCaptor.forClass(Object.class);
        ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock, (VerificationMode)Mockito.times((int)20))).emit((String)org.mockito.Matchers.eq((Object)"test_stream"), org.mockito.Matchers.anyList(), messageIds.capture());
        for (Object id : messageIds.getAllValues()) {
            this.spout.ack(id);
        }
        Time.advanceTime((long)(this.commitOffsetPeriodMs + 500L));
        this.spout.nextTuple();
        this.verifyAllMessagesCommitted(20L);
    }

    @Test
    public void testShouldEmitAllMessages() throws Exception {
        int messageCount = 10;
        this.prepareSpout(10);
        for (int i = 0; i < 10; ++i) {
            this.spout.nextTuple();
            ArgumentCaptor messageId = ArgumentCaptor.forClass(Object.class);
            ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock)).emit((String)org.mockito.Matchers.eq((Object)"test_stream"), (List)org.mockito.Matchers.eq((Object)new Values(new Object[]{"test", Integer.toString(i), Integer.toString(i)})), messageId.capture());
            this.spout.ack(messageId.getValue());
            Mockito.reset((Object[])new SpoutOutputCollector[]{this.collectorMock});
        }
        Time.advanceTime((long)(this.commitOffsetPeriodMs + 500L));
        this.spout.nextTuple();
        this.verifyAllMessagesCommitted(10L);
    }

    @Test
    public void testShouldReplayInOrderFailedMessages() throws Exception {
        int messageCount = 10;
        this.prepareSpout(10);
        ArgumentCaptor messageIdAcked = ArgumentCaptor.forClass(Object.class);
        this.spout.nextTuple();
        ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock)).emit(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyList(), messageIdAcked.capture());
        this.spout.ack(messageIdAcked.getValue());
        Mockito.reset((Object[])new SpoutOutputCollector[]{this.collectorMock});
        ArgumentCaptor messageIdFailed = ArgumentCaptor.forClass(Object.class);
        this.spout.nextTuple();
        ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock)).emit(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyList(), messageIdFailed.capture());
        this.spout.fail(messageIdFailed.getValue());
        Mockito.reset((Object[])new SpoutOutputCollector[]{this.collectorMock});
        for (int i = 0; i < 10; ++i) {
            this.spout.nextTuple();
        }
        ArgumentCaptor remainingMessageIds = ArgumentCaptor.forClass(Object.class);
        ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock, (VerificationMode)Mockito.times((int)9))).emit((String)org.mockito.Matchers.eq((Object)"test_stream"), org.mockito.Matchers.anyList(), remainingMessageIds.capture());
        for (Object id : remainingMessageIds.getAllValues()) {
            this.spout.ack(id);
        }
        Time.advanceTime((long)(this.commitOffsetPeriodMs + 500L));
        this.spout.nextTuple();
        this.verifyAllMessagesCommitted(10L);
    }

    @Test
    public void testShouldReplayFirstTupleFailedOutOfOrder() throws Exception {
        int messageCount = 10;
        this.prepareSpout(10);
        ArgumentCaptor messageIdToFail = ArgumentCaptor.forClass(Object.class);
        this.spout.nextTuple();
        ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock)).emit(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyList(), messageIdToFail.capture());
        Mockito.reset((Object[])new SpoutOutputCollector[]{this.collectorMock});
        ArgumentCaptor messageIdToAck = ArgumentCaptor.forClass(Object.class);
        this.spout.nextTuple();
        ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock)).emit(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyList(), messageIdToAck.capture());
        Mockito.reset((Object[])new SpoutOutputCollector[]{this.collectorMock});
        this.spout.ack(messageIdToAck.getValue());
        this.spout.fail(messageIdToFail.getValue());
        for (int i = 0; i < 10; ++i) {
            this.spout.nextTuple();
        }
        ArgumentCaptor remainingIds = ArgumentCaptor.forClass(Object.class);
        ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock, (VerificationMode)Mockito.times((int)9))).emit((String)org.mockito.Matchers.eq((Object)"test_stream"), org.mockito.Matchers.anyList(), remainingIds.capture());
        for (Object id : remainingIds.getAllValues()) {
            this.spout.ack(id);
        }
        Time.advanceTime((long)(this.commitOffsetPeriodMs + 500L));
        this.spout.nextTuple();
        this.verifyAllMessagesCommitted(10L);
    }

    @Test
    public void testShouldReplayAllFailedTuplesWhenFailedOutOfOrder() throws Exception {
        int messageCount = 10;
        this.prepareSpout(10);
        for (int i = 0; i < 10; ++i) {
            this.spout.nextTuple();
        }
        ArgumentCaptor messageIds = ArgumentCaptor.forClass(KafkaSpoutMessageId.class);
        ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock, (VerificationMode)Mockito.times((int)10))).emit(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyList(), messageIds.capture());
        Mockito.reset((Object[])new SpoutOutputCollector[]{this.collectorMock});
        List capturedMessageIds = messageIds.getAllValues();
        this.spout.fail(capturedMessageIds.get(5));
        this.spout.fail(capturedMessageIds.get(3));
        this.spout.nextTuple();
        this.spout.fail(capturedMessageIds.get(2));
        ArgumentCaptor reemittedMessageIds = ArgumentCaptor.forClass(KafkaSpoutMessageId.class);
        for (int i = 0; i < 10; ++i) {
            this.spout.nextTuple();
        }
        ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock, (VerificationMode)Mockito.times((int)3))).emit(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyList(), reemittedMessageIds.capture());
        HashSet expectedReemitIds = new HashSet();
        expectedReemitIds.add(capturedMessageIds.get(5));
        expectedReemitIds.add(capturedMessageIds.get(3));
        expectedReemitIds.add(capturedMessageIds.get(2));
        MatcherAssert.assertThat((String)"Expected reemits to be the 3 failed tuples", new HashSet(reemittedMessageIds.getAllValues()), (Matcher)CoreMatchers.is(expectedReemitIds));
    }

    @Test
    public void testShouldDropMessagesAfterMaxRetriesAreReached() throws Exception {
        boolean messageCount = true;
        this.prepareSpout(1);
        for (int i = 0; i <= 3; ++i) {
            ArgumentCaptor messageIdFailed = ArgumentCaptor.forClass(KafkaSpoutMessageId.class);
            this.spout.nextTuple();
            ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock)).emit(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyListOf(Object.class), messageIdFailed.capture());
            KafkaSpoutMessageId msgId = (KafkaSpoutMessageId)messageIdFailed.getValue();
            this.spout.fail((Object)msgId);
            MatcherAssert.assertThat((String)"Expected message id number of failures to match the number of times the message has failed", (Object)msgId.numFails(), (Matcher)CoreMatchers.is((Object)(i + 1)));
            Mockito.reset((Object[])new SpoutOutputCollector[]{this.collectorMock});
        }
        this.spout.nextTuple();
        ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock, (VerificationMode)Mockito.never())).emit(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyListOf(Object.class), org.mockito.Matchers.anyObject());
    }

    @Test
    public void testSpoutMustRefreshPartitionsEvenIfNotPolling() throws Exception {
        SingleTopicKafkaUnitSetupHelper.initializeSpout(this.spout, this.conf, this.topologyContext, this.collectorMock);
        this.spout.nextTuple();
        ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock, (VerificationMode)Mockito.never())).emit(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyList(), org.mockito.Matchers.any(KafkaSpoutMessageId.class));
        SingleTopicKafkaUnitSetupHelper.populateTopicData(this.kafkaUnitRule.getKafkaUnit(), "test", 1);
        Time.advanceTime((long)2500L);
        this.spout.nextTuple();
        ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock)).emit(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyList(), org.mockito.Matchers.any(KafkaSpoutMessageId.class));
    }

    @Test
    public void testOffsetMetrics() throws Exception {
        int messageCount = 10;
        this.prepareSpout(10);
        Map offsetMetric = (Map)this.spout.getKafkaOffsetMetric().getValueAndReset();
        Assert.assertEquals((long)0L, (long)((Long)offsetMetric.get("test/totalEarliestTimeOffset")));
        Assert.assertEquals((long)10L, (long)((Long)offsetMetric.get("test/totalLatestTimeOffset")));
        Assert.assertEquals((long)10L, (long)((Long)offsetMetric.get("test/totalRecordsInPartitions")));
        Assert.assertEquals((long)0L, (long)((Long)offsetMetric.get("test/totalLatestEmittedOffset")));
        Assert.assertEquals((long)0L, (long)((Long)offsetMetric.get("test/totalLatestCompletedOffset")));
        Assert.assertEquals((long)10L, (long)((Long)offsetMetric.get("test/totalSpoutLag")));
        for (int i = 0; i < 10; ++i) {
            this.nextTuple_verifyEmitted_ack_resetCollector(i);
        }
        this.commitAndVerifyAllMessagesCommitted(10L);
        offsetMetric = (Map)this.spout.getKafkaOffsetMetric().getValueAndReset();
        Assert.assertEquals((long)0L, (long)((Long)offsetMetric.get("test/totalEarliestTimeOffset")));
        Assert.assertEquals((long)10L, (long)((Long)offsetMetric.get("test/totalLatestTimeOffset")));
        Assert.assertEquals((long)9L, (long)((Long)offsetMetric.get("test/totalLatestEmittedOffset")));
        Assert.assertEquals((long)10L, (long)((Long)offsetMetric.get("test/totalLatestCompletedOffset")));
        Assert.assertEquals((long)0L, (long)((Long)offsetMetric.get("test/totalSpoutLag")));
    }
}

