/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.storm.kafka.spout.KafkaSpout;
import org.apache.storm.kafka.spout.KafkaSpoutConfig;
import org.apache.storm.kafka.spout.KafkaSpoutMessageId;
import org.apache.storm.kafka.spout.KafkaSpoutRetryExponentialBackoff;
import org.apache.storm.kafka.spout.KafkaSpoutRetryService;
import org.apache.storm.kafka.spout.SpoutWithMockedConsumerSetupHelper;
import org.apache.storm.kafka.spout.Subscription;
import org.apache.storm.kafka.spout.builders.SingleTopicKafkaSpoutConfiguration;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.utils.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class KafkaSpoutRetryLimitTest {
    private final long offsetCommitPeriodMs = 2000L;
    private final TopologyContext contextMock = (TopologyContext)Mockito.mock(TopologyContext.class);
    private final SpoutOutputCollector collectorMock = (SpoutOutputCollector)Mockito.mock(SpoutOutputCollector.class);
    private final Map<String, Object> conf = new HashMap<String, Object>();
    private final TopicPartition partition = new TopicPartition("test", 1);
    private KafkaConsumer<String, String> consumerMock;
    private KafkaSpoutConfig<String, String> spoutConfig;
    public static final KafkaSpoutRetryService ZERO_RETRIES_RETRY_SERVICE = new KafkaSpoutRetryExponentialBackoff(KafkaSpoutRetryExponentialBackoff.TimeInterval.seconds((long)0L), KafkaSpoutRetryExponentialBackoff.TimeInterval.milliSeconds((long)0L), 0, KafkaSpoutRetryExponentialBackoff.TimeInterval.milliSeconds((long)0L));
    @Captor
    private ArgumentCaptor<Map<TopicPartition, OffsetAndMetadata>> commitCapture;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.spoutConfig = SingleTopicKafkaSpoutConfiguration.createKafkaSpoutConfigBuilder((Subscription)Mockito.mock(Subscription.class), -1).setOffsetCommitPeriodMs(2000L).setRetry(ZERO_RETRIES_RETRY_SERVICE).build();
        this.consumerMock = (KafkaConsumer)Mockito.mock(KafkaConsumer.class);
    }

    @Test
    public void testFailingTupleCompletesAckAfterRetryLimitIsMet() {
        try (Time.SimulatedTime simulatedTime = new Time.SimulatedTime();){
            KafkaSpout<String, String> spout = SpoutWithMockedConsumerSetupHelper.setupSpout(this.spoutConfig, this.conf, this.contextMock, this.collectorMock, this.consumerMock, this.partition);
            HashMap records = new HashMap();
            int lastOffset = 3;
            int numRecords = lastOffset + 1;
            records.put(this.partition, SpoutWithMockedConsumerSetupHelper.createRecords(this.partition, 0L, numRecords));
            Mockito.when((Object)this.consumerMock.poll(Matchers.anyLong())).thenReturn((Object)new ConsumerRecords(records));
            for (int i = 0; i < numRecords; ++i) {
                spout.nextTuple();
            }
            ArgumentCaptor messageIds = ArgumentCaptor.forClass(KafkaSpoutMessageId.class);
            ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock, (VerificationMode)Mockito.times((int)numRecords))).emit(Matchers.anyString(), Matchers.anyList(), messageIds.capture());
            for (KafkaSpoutMessageId messageId : messageIds.getAllValues()) {
                spout.fail((Object)messageId);
            }
            Time.advanceTime((long)2500L);
            spout.nextTuple();
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.consumerMock});
            ((KafkaConsumer)inOrder.verify(this.consumerMock)).commitSync((Map)this.commitCapture.capture());
            ((KafkaConsumer)inOrder.verify(this.consumerMock)).poll(Matchers.anyLong());
            Assert.assertTrue((boolean)((Map)this.commitCapture.getValue()).containsKey(this.partition));
            Assert.assertEquals((long)(lastOffset + 1), (long)((OffsetAndMetadata)((Map)this.commitCapture.getValue()).get(this.partition)).offset());
        }
    }
}

