/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.storm.kafka.spout.KafkaSpoutMessageId;
import org.apache.storm.kafka.spout.KafkaSpoutRetryExponentialBackoff;
import org.apache.storm.utils.Time;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class KafkaSpoutRetryExponentialBackoffTest {
    private final TopicPartition testTopic = new TopicPartition("topic", 0);
    private final TopicPartition testTopic2 = new TopicPartition("other-topic", 0);

    private KafkaSpoutRetryExponentialBackoff createNoWaitRetryService() {
        return new KafkaSpoutRetryExponentialBackoff(KafkaSpoutRetryExponentialBackoff.TimeInterval.seconds((long)0L), KafkaSpoutRetryExponentialBackoff.TimeInterval.seconds((long)0L), 1, KafkaSpoutRetryExponentialBackoff.TimeInterval.seconds((long)0L));
    }

    private KafkaSpoutRetryExponentialBackoff createOneSecondWaitRetryService() {
        return new KafkaSpoutRetryExponentialBackoff(KafkaSpoutRetryExponentialBackoff.TimeInterval.seconds((long)1L), KafkaSpoutRetryExponentialBackoff.TimeInterval.seconds((long)0L), 1, KafkaSpoutRetryExponentialBackoff.TimeInterval.seconds((long)1L));
    }

    private ConsumerRecord<String, String> createRecord(TopicPartition tp, long offset) {
        return new ConsumerRecord(tp.topic(), tp.partition(), offset, null, null);
    }

    @Test
    public void testCanScheduleRetry() {
        KafkaSpoutRetryExponentialBackoff retryService = this.createNoWaitRetryService();
        long offset = 0L;
        KafkaSpoutMessageId msgId = retryService.getMessageId(this.createRecord(this.testTopic, offset));
        msgId.incrementNumFails();
        boolean scheduled = retryService.schedule(msgId);
        Assert.assertThat((String)"The service must schedule the message for retry", (Object)scheduled, (Matcher)CoreMatchers.is((Object)true));
        KafkaSpoutMessageId retrievedMessageId = retryService.getMessageId(this.createRecord(this.testTopic, offset));
        Assert.assertThat((String)"The service should return the original message id when asked for the same tp/offset twice", (Object)retrievedMessageId, (Matcher)CoreMatchers.sameInstance((Object)msgId));
        Assert.assertThat((Object)retryService.isScheduled(msgId), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)retryService.isReady(msgId), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)retryService.readyMessageCount(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)retryService.earliestRetriableOffsets(), (Matcher)CoreMatchers.is(Collections.singletonMap(this.testTopic, msgId.offset())));
    }

    @Test
    public void testCanRescheduleRetry() {
        try (Time.SimulatedTime time = new Time.SimulatedTime();){
            KafkaSpoutRetryExponentialBackoff retryService = this.createOneSecondWaitRetryService();
            long offset = 0L;
            KafkaSpoutMessageId msgId = retryService.getMessageId(this.createRecord(this.testTopic, offset));
            msgId.incrementNumFails();
            retryService.schedule(msgId);
            Time.advanceTime((long)500L);
            boolean scheduled = retryService.schedule(msgId);
            Assert.assertThat((String)"The service must be able to reschedule an already scheduled id", (Object)scheduled, (Matcher)CoreMatchers.is((Object)true));
            Time.advanceTime((long)500L);
            Assert.assertThat((String)"The message should not be ready for retry yet since it was rescheduled", (Object)retryService.isReady(msgId), (Matcher)CoreMatchers.is((Object)false));
            Assert.assertThat((Object)retryService.isScheduled(msgId), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)retryService.earliestRetriableOffsets(), (Matcher)CoreMatchers.is(Collections.emptyMap()));
            Assert.assertThat((Object)retryService.readyMessageCount(), (Matcher)CoreMatchers.is((Object)0));
            Time.advanceTime((long)500L);
            Assert.assertThat((String)"The message should be ready for retry once the full delay has passed", (Object)retryService.isReady(msgId), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)retryService.isScheduled(msgId), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)retryService.earliestRetriableOffsets(), (Matcher)CoreMatchers.is(Collections.singletonMap(this.testTopic, msgId.offset())));
            Assert.assertThat((Object)retryService.readyMessageCount(), (Matcher)CoreMatchers.is((Object)1));
        }
    }

    @Test
    public void testCannotContainMultipleSchedulesForId() {
        try (Time.SimulatedTime time = new Time.SimulatedTime();){
            KafkaSpoutRetryExponentialBackoff retryService = this.createOneSecondWaitRetryService();
            long offset = 0L;
            KafkaSpoutMessageId msgId = retryService.getMessageId(this.createRecord(this.testTopic, offset));
            msgId.incrementNumFails();
            retryService.schedule(msgId);
            Time.advanceTime((long)500L);
            boolean scheduled = retryService.schedule(msgId);
            retryService.remove(msgId);
            Assert.assertThat((String)"The message should no longer be scheduled", (Object)retryService.isScheduled(msgId), (Matcher)CoreMatchers.is((Object)false));
            Time.advanceTime((long)500L);
            Assert.assertThat((String)"The message should not be ready for retry because it isn't scheduled", (Object)retryService.isReady(msgId), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    @Test
    public void testCanRemoveRetry() {
        KafkaSpoutRetryExponentialBackoff retryService = this.createNoWaitRetryService();
        long offset = 0L;
        KafkaSpoutMessageId msgId = retryService.getMessageId(this.createRecord(this.testTopic, offset));
        msgId.incrementNumFails();
        retryService.schedule(msgId);
        boolean removed = retryService.remove(msgId);
        Assert.assertThat((Object)removed, (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)retryService.isScheduled(msgId), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)retryService.isReady(msgId), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)retryService.earliestRetriableOffsets(), (Matcher)CoreMatchers.is(Collections.emptyMap()));
        Assert.assertThat((Object)retryService.readyMessageCount(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testCanHandleMultipleTopics() {
        try (Time.SimulatedTime time = new Time.SimulatedTime();){
            KafkaSpoutRetryExponentialBackoff retryService = this.createOneSecondWaitRetryService();
            long offset = 0L;
            KafkaSpoutMessageId msgIdTp1 = retryService.getMessageId(this.createRecord(this.testTopic, offset));
            KafkaSpoutMessageId msgIdTp2 = retryService.getMessageId(this.createRecord(this.testTopic2, offset));
            msgIdTp1.incrementNumFails();
            msgIdTp2.incrementNumFails();
            boolean scheduledOne = retryService.schedule(msgIdTp1);
            Time.advanceTime((long)500L);
            boolean scheduledTwo = retryService.schedule(msgIdTp2);
            Assert.assertThat((Object)scheduledOne, (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)retryService.isScheduled(msgIdTp1), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)scheduledTwo, (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)retryService.isScheduled(msgIdTp2), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)retryService.isReady(msgIdTp1), (Matcher)CoreMatchers.is((Object)false));
            Assert.assertThat((Object)retryService.isReady(msgIdTp2), (Matcher)CoreMatchers.is((Object)false));
            Time.advanceTime((long)500L);
            Assert.assertThat((Object)retryService.isReady(msgIdTp1), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)retryService.isReady(msgIdTp2), (Matcher)CoreMatchers.is((Object)false));
            Assert.assertThat((Object)retryService.earliestRetriableOffsets(), (Matcher)CoreMatchers.is(Collections.singletonMap(this.testTopic, offset)));
            Time.advanceTime((long)500L);
            Assert.assertThat((Object)retryService.isReady(msgIdTp2), (Matcher)CoreMatchers.is((Object)true));
            HashMap<TopicPartition, Long> earliestOffsets = new HashMap<TopicPartition, Long>();
            earliestOffsets.put(this.testTopic, offset);
            earliestOffsets.put(this.testTopic2, offset);
            Assert.assertThat((Object)retryService.earliestRetriableOffsets(), (Matcher)CoreMatchers.is(earliestOffsets));
            retryService.retainAll(Collections.singleton(this.testTopic2));
            Assert.assertThat((Object)retryService.isScheduled(msgIdTp1), (Matcher)CoreMatchers.is((Object)false));
            Assert.assertThat((Object)retryService.isScheduled(msgIdTp2), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)retryService.isReady(msgIdTp1), (Matcher)CoreMatchers.is((Object)false));
            Assert.assertThat((Object)retryService.isReady(msgIdTp2), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)retryService.earliestRetriableOffsets(), (Matcher)CoreMatchers.is(Collections.singletonMap(this.testTopic2, offset)));
        }
    }

    @Test
    public void testCanHandleMultipleMessagesOnPartition() {
        try (Time.SimulatedTime time = new Time.SimulatedTime();){
            KafkaSpoutRetryExponentialBackoff retryService = this.createOneSecondWaitRetryService();
            long offset = 0L;
            KafkaSpoutMessageId msgIdEarliest = retryService.getMessageId(this.createRecord(this.testTopic, offset));
            KafkaSpoutMessageId msgIdLatest = retryService.getMessageId(this.createRecord(this.testTopic, offset + 1L));
            msgIdEarliest.incrementNumFails();
            msgIdLatest.incrementNumFails();
            retryService.schedule(msgIdEarliest);
            Time.advanceTime((long)500L);
            retryService.schedule(msgIdLatest);
            Assert.assertThat((Object)retryService.isScheduled(msgIdEarliest), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)retryService.isScheduled(msgIdLatest), (Matcher)CoreMatchers.is((Object)true));
            Time.advanceTime((long)500L);
            Assert.assertThat((Object)retryService.isReady(msgIdEarliest), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)retryService.isReady(msgIdLatest), (Matcher)CoreMatchers.is((Object)false));
            Assert.assertThat((Object)retryService.earliestRetriableOffsets(), (Matcher)CoreMatchers.is(Collections.singletonMap(this.testTopic, msgIdEarliest.offset())));
            Time.advanceTime((long)500L);
            Assert.assertThat((Object)retryService.isReady(msgIdEarliest), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)retryService.isReady(msgIdLatest), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)retryService.earliestRetriableOffsets(), (Matcher)CoreMatchers.is(Collections.singletonMap(this.testTopic, msgIdEarliest.offset())));
            retryService.remove(msgIdEarliest);
            Assert.assertThat((Object)retryService.earliestRetriableOffsets(), (Matcher)CoreMatchers.is(Collections.singletonMap(this.testTopic, msgIdLatest.offset())));
        }
    }

    @Test
    public void testMaxRetries() {
        try (Time.SimulatedTime time = new Time.SimulatedTime();){
            int maxRetries = 3;
            KafkaSpoutRetryExponentialBackoff retryService = new KafkaSpoutRetryExponentialBackoff(KafkaSpoutRetryExponentialBackoff.TimeInterval.seconds((long)0L), KafkaSpoutRetryExponentialBackoff.TimeInterval.seconds((long)0L), maxRetries, KafkaSpoutRetryExponentialBackoff.TimeInterval.seconds((long)0L));
            long offset = 0L;
            KafkaSpoutMessageId msgId = retryService.getMessageId(this.createRecord(this.testTopic, offset));
            for (int i = 0; i < maxRetries; ++i) {
                msgId.incrementNumFails();
            }
            boolean scheduled = retryService.schedule(msgId);
            Assert.assertThat((Object)scheduled, (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)retryService.isScheduled(msgId), (Matcher)CoreMatchers.is((Object)true));
            retryService.remove(msgId);
            msgId.incrementNumFails();
            boolean rescheduled = retryService.schedule(msgId);
            Assert.assertThat((String)"The message should not be allowed to retry once the limit is reached", (Object)rescheduled, (Matcher)CoreMatchers.is((Object)false));
            Assert.assertThat((Object)retryService.isScheduled(msgId), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    @Test
    public void testMaxDelay() {
        try (Time.SimulatedTime time = new Time.SimulatedTime();){
            int maxDelaySecs = 2;
            KafkaSpoutRetryExponentialBackoff retryService = new KafkaSpoutRetryExponentialBackoff(KafkaSpoutRetryExponentialBackoff.TimeInterval.seconds((long)500L), KafkaSpoutRetryExponentialBackoff.TimeInterval.seconds((long)0L), 1, KafkaSpoutRetryExponentialBackoff.TimeInterval.seconds((long)maxDelaySecs));
            long offset = 0L;
            KafkaSpoutMessageId msgId = retryService.getMessageId(this.createRecord(this.testTopic, offset));
            msgId.incrementNumFails();
            retryService.schedule(msgId);
            Time.advanceTimeSecs((long)maxDelaySecs);
            Assert.assertThat((String)"The message should be ready for retry after the max delay", (Object)retryService.isReady(msgId), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    private void validateBackoff(int expectedBackoffSeconds, KafkaSpoutMessageId msgId, KafkaSpoutRetryExponentialBackoff retryService) {
        Time.advanceTimeSecs((long)(expectedBackoffSeconds - 1));
        Assert.assertThat((String)"The message should not be ready for retry until the backoff has expired", (Object)retryService.isReady(msgId), (Matcher)CoreMatchers.is((Object)false));
        Time.advanceTimeSecs((long)1L);
        Assert.assertThat((Object)retryService.isReady(msgId), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testExponentialBackoff() {
        try (Time.SimulatedTime time = new Time.SimulatedTime();){
            KafkaSpoutRetryExponentialBackoff retryService = new KafkaSpoutRetryExponentialBackoff(KafkaSpoutRetryExponentialBackoff.TimeInterval.seconds((long)0L), KafkaSpoutRetryExponentialBackoff.TimeInterval.seconds((long)4L), Integer.MAX_VALUE, KafkaSpoutRetryExponentialBackoff.TimeInterval.seconds((long)Integer.MAX_VALUE));
            long offset = 0L;
            KafkaSpoutMessageId msgId = retryService.getMessageId(this.createRecord(this.testTopic, offset));
            msgId.incrementNumFails();
            msgId.incrementNumFails();
            List<Integer> expectedBackoffsSecs = Arrays.asList(8, 16, 32);
            for (Integer expectedBackoffSecs : expectedBackoffsSecs) {
                retryService.schedule(msgId);
                Time.advanceTimeSecs((long)(expectedBackoffSecs - 1));
                Assert.assertThat((String)("The message should not be ready for retry until backoff " + expectedBackoffSecs + " has expired"), (Object)retryService.isReady(msgId), (Matcher)CoreMatchers.is((Object)false));
                Time.advanceTimeSecs((long)1L);
                Assert.assertThat((String)("The message should be ready for retry once backoff " + expectedBackoffSecs + " has expired"), (Object)retryService.isReady(msgId), (Matcher)CoreMatchers.is((Object)true));
                msgId.incrementNumFails();
                retryService.remove(msgId);
            }
        }
    }
}

