/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.storm.kafka.spout.KafkaSpout;
import org.apache.storm.kafka.spout.KafkaSpoutConfig;
import org.apache.storm.kafka.spout.KafkaSpoutMessageId;
import org.apache.storm.kafka.spout.KafkaSpoutRetryService;
import org.apache.storm.kafka.spout.SpoutWithMockedConsumerSetupHelper;
import org.apache.storm.kafka.spout.Subscription;
import org.apache.storm.kafka.spout.builders.SingleTopicKafkaSpoutConfiguration;
import org.apache.storm.kafka.spout.internal.KafkaConsumerFactory;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.utils.Time;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class KafkaSpoutRebalanceTest {
    @Captor
    private ArgumentCaptor<Map<TopicPartition, OffsetAndMetadata>> commitCapture;
    private final long offsetCommitPeriodMs = 2000L;
    private final Map<String, Object> conf = new HashMap<String, Object>();
    private TopologyContext contextMock;
    private SpoutOutputCollector collectorMock;
    private KafkaConsumer<String, String> consumerMock;
    private KafkaConsumerFactory<String, String> consumerFactoryMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.contextMock = (TopologyContext)Mockito.mock(TopologyContext.class);
        this.collectorMock = (SpoutOutputCollector)Mockito.mock(SpoutOutputCollector.class);
        this.consumerMock = (KafkaConsumer)Mockito.mock(KafkaConsumer.class);
        this.consumerFactoryMock = new KafkaConsumerFactory<String, String>(){

            public KafkaConsumer<String, String> createConsumer(KafkaSpoutConfig<String, String> kafkaSpoutConfig) {
                return KafkaSpoutRebalanceTest.this.consumerMock;
            }
        };
    }

    private List<KafkaSpoutMessageId> emitOneMessagePerPartitionThenRevokeOnePartition(KafkaSpout<String, String> spout, TopicPartition partitionThatWillBeRevoked, TopicPartition assignedPartition, ArgumentCaptor<ConsumerRebalanceListener> rebalanceListenerCapture) {
        spout.open(this.conf, this.contextMock, this.collectorMock);
        spout.activate();
        ConsumerRebalanceListener consumerRebalanceListener = (ConsumerRebalanceListener)rebalanceListenerCapture.getValue();
        HashSet<TopicPartition> assignedPartitions = new HashSet<TopicPartition>();
        assignedPartitions.add(partitionThatWillBeRevoked);
        assignedPartitions.add(assignedPartition);
        consumerRebalanceListener.onPartitionsAssigned(assignedPartitions);
        Mockito.when((Object)this.consumerMock.assignment()).thenReturn(assignedPartitions);
        Mockito.when((Object)this.consumerMock.poll(org.mockito.Matchers.anyLong())).thenReturn((Object)new ConsumerRecords(Collections.singletonMap(partitionThatWillBeRevoked, SpoutWithMockedConsumerSetupHelper.createRecords(partitionThatWillBeRevoked, 0L, 1)))).thenReturn((Object)new ConsumerRecords(Collections.singletonMap(assignedPartition, SpoutWithMockedConsumerSetupHelper.createRecords(assignedPartition, 0L, 1)))).thenReturn((Object)new ConsumerRecords(new HashMap()));
        spout.nextTuple();
        ArgumentCaptor messageIdForRevokedPartition = ArgumentCaptor.forClass(KafkaSpoutMessageId.class);
        ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock)).emit(Mockito.anyString(), Mockito.anyList(), messageIdForRevokedPartition.capture());
        Mockito.reset((Object[])new SpoutOutputCollector[]{this.collectorMock});
        spout.nextTuple();
        ArgumentCaptor messageIdForAssignedPartition = ArgumentCaptor.forClass(KafkaSpoutMessageId.class);
        ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock)).emit(Mockito.anyString(), Mockito.anyList(), messageIdForAssignedPartition.capture());
        consumerRebalanceListener.onPartitionsRevoked(assignedPartitions);
        consumerRebalanceListener.onPartitionsAssigned(Collections.singleton(assignedPartition));
        Mockito.when((Object)this.consumerMock.assignment()).thenReturn(Collections.singleton(assignedPartition));
        ArrayList<KafkaSpoutMessageId> emittedMessageIds = new ArrayList<KafkaSpoutMessageId>();
        emittedMessageIds.add((KafkaSpoutMessageId)messageIdForRevokedPartition.getValue());
        emittedMessageIds.add((KafkaSpoutMessageId)messageIdForAssignedPartition.getValue());
        return emittedMessageIds;
    }

    @Test
    public void spoutMustIgnoreAcksForTuplesItIsNotAssignedAfterRebalance() throws Exception {
        try (Time.SimulatedTime simulatedTime = new Time.SimulatedTime();){
            ArgumentCaptor rebalanceListenerCapture = ArgumentCaptor.forClass(ConsumerRebalanceListener.class);
            Subscription subscriptionMock = (Subscription)Mockito.mock(Subscription.class);
            ((Subscription)Mockito.doNothing().when((Object)subscriptionMock)).subscribe((KafkaConsumer)org.mockito.Matchers.any(KafkaConsumer.class), (ConsumerRebalanceListener)rebalanceListenerCapture.capture(), (TopologyContext)org.mockito.Matchers.any(TopologyContext.class));
            KafkaSpout spout = new KafkaSpout(SingleTopicKafkaSpoutConfiguration.createKafkaSpoutConfigBuilder(subscriptionMock, -1).setOffsetCommitPeriodMs(2000L).build(), this.consumerFactoryMock);
            String topic = "test";
            TopicPartition partitionThatWillBeRevoked = new TopicPartition(topic, 1);
            TopicPartition assignedPartition = new TopicPartition(topic, 2);
            List<KafkaSpoutMessageId> emittedMessageIds = this.emitOneMessagePerPartitionThenRevokeOnePartition((KafkaSpout<String, String>)spout, partitionThatWillBeRevoked, assignedPartition, (ArgumentCaptor<ConsumerRebalanceListener>)rebalanceListenerCapture);
            spout.ack((Object)emittedMessageIds.get(0));
            spout.ack((Object)emittedMessageIds.get(1));
            Time.advanceTime((long)2500L);
            spout.nextTuple();
            ((KafkaConsumer)Mockito.verify(this.consumerMock, (VerificationMode)Mockito.times((int)1))).commitSync((Map)this.commitCapture.capture());
            Map commitCaptureMap = (Map)this.commitCapture.getValue();
            Assert.assertThat((Object)commitCaptureMap, (Matcher)Matchers.hasKey((Object)assignedPartition));
            Assert.assertThat((Object)commitCaptureMap, (Matcher)CoreMatchers.not((Matcher)Matchers.hasKey((Object)partitionThatWillBeRevoked)));
        }
    }

    @Test
    public void spoutMustIgnoreFailsForTuplesItIsNotAssignedAfterRebalance() throws Exception {
        ArgumentCaptor rebalanceListenerCapture = ArgumentCaptor.forClass(ConsumerRebalanceListener.class);
        Subscription subscriptionMock = (Subscription)Mockito.mock(Subscription.class);
        ((Subscription)Mockito.doNothing().when((Object)subscriptionMock)).subscribe((KafkaConsumer)org.mockito.Matchers.any(KafkaConsumer.class), (ConsumerRebalanceListener)rebalanceListenerCapture.capture(), (TopologyContext)org.mockito.Matchers.any(TopologyContext.class));
        KafkaSpoutRetryService retryServiceMock = (KafkaSpoutRetryService)Mockito.mock(KafkaSpoutRetryService.class);
        KafkaSpout spout = new KafkaSpout(SingleTopicKafkaSpoutConfiguration.createKafkaSpoutConfigBuilder(subscriptionMock, -1).setOffsetCommitPeriodMs(10L).setRetry(retryServiceMock).build(), this.consumerFactoryMock);
        String topic = "test";
        TopicPartition partitionThatWillBeRevoked = new TopicPartition(topic, 1);
        TopicPartition assignedPartition = new TopicPartition(topic, 2);
        Mockito.when((Object)retryServiceMock.getMessageId((ConsumerRecord)Mockito.any(ConsumerRecord.class))).thenReturn((Object)new KafkaSpoutMessageId(partitionThatWillBeRevoked, 0L)).thenReturn((Object)new KafkaSpoutMessageId(assignedPartition, 0L));
        List<KafkaSpoutMessageId> emittedMessageIds = this.emitOneMessagePerPartitionThenRevokeOnePartition((KafkaSpout<String, String>)spout, partitionThatWillBeRevoked, assignedPartition, (ArgumentCaptor<ConsumerRebalanceListener>)rebalanceListenerCapture);
        ((KafkaSpoutRetryService)Mockito.verify((Object)retryServiceMock, (VerificationMode)Mockito.times((int)2))).getMessageId((ConsumerRecord)Mockito.any(ConsumerRecord.class));
        spout.fail((Object)emittedMessageIds.get(0));
        spout.fail((Object)emittedMessageIds.get(1));
        ((KafkaSpoutRetryService)Mockito.verify((Object)retryServiceMock, (VerificationMode)Mockito.never())).schedule(emittedMessageIds.get(0));
        ((KafkaSpoutRetryService)Mockito.verify((Object)retryServiceMock)).schedule(emittedMessageIds.get(1));
    }

    @Test
    public void testReassignPartitionSeeksForOnlyNewPartitions() {
        ArgumentCaptor rebalanceListenerCapture = ArgumentCaptor.forClass(ConsumerRebalanceListener.class);
        Subscription subscriptionMock = (Subscription)Mockito.mock(Subscription.class);
        ((Subscription)Mockito.doNothing().when((Object)subscriptionMock)).subscribe((KafkaConsumer)org.mockito.Matchers.any(KafkaConsumer.class), (ConsumerRebalanceListener)rebalanceListenerCapture.capture(), (TopologyContext)org.mockito.Matchers.any(TopologyContext.class));
        KafkaSpout spout = new KafkaSpout(SingleTopicKafkaSpoutConfiguration.createKafkaSpoutConfigBuilder(subscriptionMock, -1).setFirstPollOffsetStrategy(KafkaSpoutConfig.FirstPollOffsetStrategy.UNCOMMITTED_EARLIEST).build(), this.consumerFactoryMock);
        String topic = "test";
        TopicPartition assignedPartition = new TopicPartition(topic, 1);
        TopicPartition newPartition = new TopicPartition(topic, 2);
        spout.open(this.conf, this.contextMock, this.collectorMock);
        spout.activate();
        ConsumerRebalanceListener consumerRebalanceListener = (ConsumerRebalanceListener)rebalanceListenerCapture.getValue();
        HashSet<TopicPartition> assignedPartitions = new HashSet<TopicPartition>();
        assignedPartitions.add(assignedPartition);
        consumerRebalanceListener.onPartitionsAssigned(assignedPartitions);
        Mockito.reset((Object[])new KafkaConsumer[]{this.consumerMock});
        long committedOffset = 500L;
        Mockito.when((Object)this.consumerMock.committed(assignedPartition)).thenReturn((Object)new OffsetAndMetadata(committedOffset));
        Mockito.when((Object)this.consumerMock.committed(newPartition)).thenReturn((Object)new OffsetAndMetadata(committedOffset));
        consumerRebalanceListener.onPartitionsRevoked(assignedPartitions);
        HashSet<TopicPartition> newAssignedPartitions = new HashSet<TopicPartition>();
        newAssignedPartitions.add(assignedPartition);
        newAssignedPartitions.add(newPartition);
        consumerRebalanceListener.onPartitionsAssigned(newAssignedPartitions);
        ((KafkaConsumer)Mockito.verify(this.consumerMock, (VerificationMode)Mockito.never())).seek((TopicPartition)org.mockito.Matchers.eq((Object)assignedPartition), org.mockito.Matchers.anyLong());
        ((KafkaConsumer)Mockito.verify(this.consumerMock)).seek(newPartition, committedOffset);
    }
}

