/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.storm.kafka.KafkaUnitRule;
import org.apache.storm.kafka.spout.KafkaSpout;
import org.apache.storm.kafka.spout.KafkaSpoutConfig;
import org.apache.storm.kafka.spout.KafkaSpoutMessageId;
import org.apache.storm.kafka.spout.SingleTopicKafkaUnitSetupHelper;
import org.apache.storm.kafka.spout.builders.SingleTopicKafkaSpoutConfiguration;
import org.apache.storm.kafka.spout.internal.KafkaConsumerFactory;
import org.apache.storm.kafka.spout.internal.KafkaConsumerFactoryDefault;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.utils.Time;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class KafkaSpoutReactivationTest {
    @Rule
    public KafkaUnitRule kafkaUnitRule = new KafkaUnitRule();
    @Captor
    private ArgumentCaptor<Map<TopicPartition, OffsetAndMetadata>> commitCapture;
    private final TopologyContext topologyContext = (TopologyContext)Mockito.mock(TopologyContext.class);
    private final Map<String, Object> conf = new HashMap<String, Object>();
    private final SpoutOutputCollector collector = (SpoutOutputCollector)Mockito.mock(SpoutOutputCollector.class);
    private final long commitOffsetPeriodMs = 2000L;
    private KafkaConsumer<String, String> consumerSpy;
    private KafkaConsumer<String, String> postReactivationConsumerSpy;
    private KafkaSpout<String, String> spout;
    private final int maxPollRecords = 10;

    @Before
    public void setUp() {
        KafkaSpoutConfig spoutConfig = SingleTopicKafkaSpoutConfiguration.setCommonSpoutConfig((KafkaSpoutConfig.Builder<String, String>)KafkaSpoutConfig.builder((String)("127.0.0.1:" + this.kafkaUnitRule.getKafkaUnit().getKafkaPort()), (String[])new String[]{"test"})).setFirstPollOffsetStrategy(KafkaSpoutConfig.FirstPollOffsetStrategy.UNCOMMITTED_EARLIEST).setOffsetCommitPeriodMs(2000L).setProp("max.poll.records", (Object)10).build();
        KafkaConsumerFactoryDefault consumerFactory = new KafkaConsumerFactoryDefault();
        this.consumerSpy = (KafkaConsumer)Mockito.spy((Object)consumerFactory.createConsumer(spoutConfig));
        this.postReactivationConsumerSpy = (KafkaConsumer)Mockito.spy((Object)consumerFactory.createConsumer(spoutConfig));
        KafkaConsumerFactory consumerFactoryMock = (KafkaConsumerFactory)Mockito.mock(KafkaConsumerFactory.class);
        Mockito.when((Object)consumerFactoryMock.createConsumer((KafkaSpoutConfig)Matchers.any(KafkaSpoutConfig.class))).thenReturn(this.consumerSpy).thenReturn(this.postReactivationConsumerSpy);
        this.spout = new KafkaSpout(spoutConfig, consumerFactoryMock);
    }

    private void prepareSpout(int messageCount) throws Exception {
        SingleTopicKafkaUnitSetupHelper.populateTopicData(this.kafkaUnitRule.getKafkaUnit(), "test", messageCount);
        SingleTopicKafkaUnitSetupHelper.initializeSpout(this.spout, this.conf, this.topologyContext, this.collector);
    }

    private KafkaSpoutMessageId emitOne() {
        ArgumentCaptor messageId = ArgumentCaptor.forClass(KafkaSpoutMessageId.class);
        this.spout.nextTuple();
        ((SpoutOutputCollector)Mockito.verify((Object)this.collector)).emit(Matchers.anyString(), Matchers.anyList(), messageId.capture());
        Mockito.reset((Object[])new SpoutOutputCollector[]{this.collector});
        return (KafkaSpoutMessageId)messageId.getValue();
    }

    @Test
    public void testSpoutMustHandleReactivationGracefully() throws Exception {
        try (Time.SimulatedTime time = new Time.SimulatedTime();){
            int messageCount = 20;
            this.prepareSpout(messageCount);
            int beforeReactivationEmits = 7;
            for (int i = 0; i < beforeReactivationEmits - 1; ++i) {
                KafkaSpoutMessageId msgId = this.emitOne();
                this.spout.ack((Object)msgId);
            }
            KafkaSpoutMessageId ackAfterDeactivateMessageId = this.emitOne();
            this.spout.deactivate();
            SingleTopicKafkaUnitSetupHelper.verifyAllMessagesCommitted(this.consumerSpy, this.commitCapture, beforeReactivationEmits - 1);
            this.spout.ack((Object)ackAfterDeactivateMessageId);
            this.spout.activate();
            for (int i = beforeReactivationEmits; i < messageCount; ++i) {
                KafkaSpoutMessageId msgId = this.emitOne();
                this.spout.ack((Object)msgId);
            }
            Time.advanceTime((long)2500L);
            this.spout.nextTuple();
            SingleTopicKafkaUnitSetupHelper.verifyAllMessagesCommitted(this.postReactivationConsumerSpy, this.commitCapture, messageCount);
            Mockito.reset((Object[])new SpoutOutputCollector[]{this.collector});
            this.spout.nextTuple();
            ((SpoutOutputCollector)Mockito.verify((Object)this.collector, (VerificationMode)Mockito.never())).emit(Matchers.anyString(), Matchers.anyList(), Matchers.any(KafkaSpoutMessageId.class));
        }
    }
}

