/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.TopicPartition;
import org.apache.storm.kafka.spout.KafkaSpout;
import org.apache.storm.kafka.spout.KafkaSpoutConfig;
import org.apache.storm.kafka.spout.KafkaSpoutMessageId;
import org.apache.storm.kafka.spout.SpoutWithMockedConsumerSetupHelper;
import org.apache.storm.kafka.spout.Subscription;
import org.apache.storm.kafka.spout.builders.SingleTopicKafkaSpoutConfiguration;
import org.apache.storm.kafka.spout.internal.CommitMetadataManager;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.utils.Time;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatcher;
import org.mockito.Captor;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class KafkaSpoutMessagingGuaranteeTest {
    @Captor
    private ArgumentCaptor<Map<TopicPartition, OffsetAndMetadata>> commitCapture;
    private final TopologyContext contextMock = (TopologyContext)Mockito.mock(TopologyContext.class);
    private final SpoutOutputCollector collectorMock = (SpoutOutputCollector)Mockito.mock(SpoutOutputCollector.class);
    private final Map<String, Object> conf = new HashMap<String, Object>();
    private final TopicPartition partition = new TopicPartition("test", 1);
    private KafkaConsumer<String, String> consumerMock;

    @Before
    public void setUp() {
        this.consumerMock = (KafkaConsumer)Mockito.mock(KafkaConsumer.class);
    }

    @Test
    public void testAtMostOnceModeCommitsBeforeEmit() throws Exception {
        KafkaSpoutConfig spoutConfig = SingleTopicKafkaSpoutConfiguration.createKafkaSpoutConfigBuilder((Subscription)Mockito.mock(Subscription.class), -1).setProcessingGuarantee(KafkaSpoutConfig.ProcessingGuarantee.AT_MOST_ONCE).build();
        KafkaSpout<String, String> spout = SpoutWithMockedConsumerSetupHelper.setupSpout(spoutConfig, this.conf, this.contextMock, this.collectorMock, this.consumerMock, this.partition);
        Mockito.when((Object)this.consumerMock.poll(Matchers.anyLong())).thenReturn((Object)new ConsumerRecords(Collections.singletonMap(this.partition, SpoutWithMockedConsumerSetupHelper.createRecords(this.partition, 0L, 1))));
        spout.nextTuple();
        Mockito.when((Object)this.consumerMock.position(this.partition)).thenReturn((Object)1L);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.consumerMock, this.collectorMock});
        ((KafkaConsumer)inOrder.verify(this.consumerMock)).poll(Matchers.anyLong());
        ((KafkaConsumer)inOrder.verify(this.consumerMock)).commitSync((Map)this.commitCapture.capture());
        ((SpoutOutputCollector)inOrder.verify((Object)this.collectorMock)).emit((String)Matchers.eq((Object)"test_stream"), Matchers.anyList());
        CommitMetadataManager metadataManager = new CommitMetadataManager(this.contextMock, KafkaSpoutConfig.ProcessingGuarantee.AT_MOST_ONCE);
        Map committedOffsets = (Map)this.commitCapture.getValue();
        Assert.assertThat((Object)((OffsetAndMetadata)committedOffsets.get(this.partition)).offset(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)((OffsetAndMetadata)committedOffsets.get(this.partition)).metadata(), (Matcher)CoreMatchers.is((Object)metadataManager.getCommitMetadata()));
    }

    private void doTestModeDisregardsMaxUncommittedOffsets(KafkaSpoutConfig<String, String> spoutConfig) {
        KafkaSpout<String, String> spout = SpoutWithMockedConsumerSetupHelper.setupSpout(spoutConfig, this.conf, this.contextMock, this.collectorMock, this.consumerMock, this.partition);
        Mockito.when((Object)this.consumerMock.poll(Matchers.anyLong())).thenReturn((Object)new ConsumerRecords(Collections.singletonMap(this.partition, SpoutWithMockedConsumerSetupHelper.createRecords(this.partition, 0L, spoutConfig.getMaxUncommittedOffsets())))).thenReturn((Object)new ConsumerRecords(Collections.singletonMap(this.partition, SpoutWithMockedConsumerSetupHelper.createRecords(this.partition, spoutConfig.getMaxUncommittedOffsets() - 1, spoutConfig.getMaxUncommittedOffsets()))));
        for (int i = 0; i < spoutConfig.getMaxUncommittedOffsets() * 2; ++i) {
            spout.nextTuple();
        }
        ((KafkaConsumer)Mockito.verify(this.consumerMock, (VerificationMode)Mockito.times((int)2))).poll(Matchers.anyLong());
        ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock, (VerificationMode)Mockito.times((int)(spoutConfig.getMaxUncommittedOffsets() * 2)))).emit((String)Matchers.eq((Object)"test_stream"), Matchers.anyList());
    }

    @Test
    public void testAtMostOnceModeDisregardsMaxUncommittedOffsets() throws Exception {
        KafkaSpoutConfig spoutConfig = SingleTopicKafkaSpoutConfiguration.createKafkaSpoutConfigBuilder((Subscription)Mockito.mock(Subscription.class), -1).setProcessingGuarantee(KafkaSpoutConfig.ProcessingGuarantee.AT_MOST_ONCE).build();
        this.doTestModeDisregardsMaxUncommittedOffsets((KafkaSpoutConfig<String, String>)spoutConfig);
    }

    @Test
    public void testNoGuaranteeModeDisregardsMaxUncommittedOffsets() throws Exception {
        KafkaSpoutConfig spoutConfig = SingleTopicKafkaSpoutConfiguration.createKafkaSpoutConfigBuilder((Subscription)Mockito.mock(Subscription.class), -1).setProcessingGuarantee(KafkaSpoutConfig.ProcessingGuarantee.NO_GUARANTEE).build();
        this.doTestModeDisregardsMaxUncommittedOffsets((KafkaSpoutConfig<String, String>)spoutConfig);
    }

    private void doTestModeCannotReplayTuples(KafkaSpoutConfig<String, String> spoutConfig) {
        KafkaSpout<String, String> spout = SpoutWithMockedConsumerSetupHelper.setupSpout(spoutConfig, this.conf, this.contextMock, this.collectorMock, this.consumerMock, this.partition);
        Mockito.when((Object)this.consumerMock.poll(Matchers.anyLong())).thenReturn((Object)new ConsumerRecords(Collections.singletonMap(this.partition, SpoutWithMockedConsumerSetupHelper.createRecords(this.partition, 0L, 1))));
        spout.nextTuple();
        ArgumentCaptor msgIdCaptor = ArgumentCaptor.forClass(KafkaSpoutMessageId.class);
        ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock)).emit((String)Matchers.eq((Object)"test_stream"), Matchers.anyList(), msgIdCaptor.capture());
        Assert.assertThat((String)"Should have captured a message id", (Object)msgIdCaptor.getValue(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        spout.fail(msgIdCaptor.getValue());
        Mockito.reset((Object[])new KafkaConsumer[]{this.consumerMock});
        Mockito.when((Object)this.consumerMock.poll(Matchers.anyLong())).thenReturn((Object)new ConsumerRecords(Collections.singletonMap(this.partition, SpoutWithMockedConsumerSetupHelper.createRecords(this.partition, 1L, 1))));
        spout.nextTuple();
        ((KafkaConsumer)Mockito.verify(this.consumerMock, (VerificationMode)Mockito.never())).seek((TopicPartition)Matchers.eq((Object)this.partition), Matchers.anyLong());
    }

    @Test
    public void testAtMostOnceModeCannotReplayTuples() throws Exception {
        KafkaSpoutConfig spoutConfig = SingleTopicKafkaSpoutConfiguration.createKafkaSpoutConfigBuilder((Subscription)Mockito.mock(Subscription.class), -1).setProcessingGuarantee(KafkaSpoutConfig.ProcessingGuarantee.AT_MOST_ONCE).setTupleTrackingEnforced(true).build();
        this.doTestModeCannotReplayTuples((KafkaSpoutConfig<String, String>)spoutConfig);
    }

    @Test
    public void testNoGuaranteeModeCannotReplayTuples() throws Exception {
        KafkaSpoutConfig spoutConfig = SingleTopicKafkaSpoutConfiguration.createKafkaSpoutConfigBuilder((Subscription)Mockito.mock(Subscription.class), -1).setProcessingGuarantee(KafkaSpoutConfig.ProcessingGuarantee.NO_GUARANTEE).setTupleTrackingEnforced(true).build();
        this.doTestModeCannotReplayTuples((KafkaSpoutConfig<String, String>)spoutConfig);
    }

    @Test
    public void testAtMostOnceModeDoesNotCommitAckedTuples() throws Exception {
        KafkaSpoutConfig spoutConfig = SingleTopicKafkaSpoutConfiguration.createKafkaSpoutConfigBuilder((Subscription)Mockito.mock(Subscription.class), -1).setProcessingGuarantee(KafkaSpoutConfig.ProcessingGuarantee.AT_MOST_ONCE).setTupleTrackingEnforced(true).build();
        try (Time.SimulatedTime time = new Time.SimulatedTime();){
            KafkaSpout<String, String> spout = SpoutWithMockedConsumerSetupHelper.setupSpout(spoutConfig, this.conf, this.contextMock, this.collectorMock, this.consumerMock, this.partition);
            Mockito.when((Object)this.consumerMock.poll(Matchers.anyLong())).thenReturn((Object)new ConsumerRecords(Collections.singletonMap(this.partition, SpoutWithMockedConsumerSetupHelper.createRecords(this.partition, 0L, 1))));
            spout.nextTuple();
            Mockito.reset((Object[])new KafkaConsumer[]{this.consumerMock});
            ArgumentCaptor msgIdCaptor = ArgumentCaptor.forClass(KafkaSpoutMessageId.class);
            ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock)).emit((String)Matchers.eq((Object)"test_stream"), Matchers.anyList(), msgIdCaptor.capture());
            Assert.assertThat((String)"Should have captured a message id", (Object)msgIdCaptor.getValue(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
            spout.ack(msgIdCaptor.getValue());
            Time.advanceTime((long)(500L + spoutConfig.getOffsetsCommitPeriodMs()));
            Mockito.when((Object)this.consumerMock.poll(Matchers.anyLong())).thenReturn((Object)new ConsumerRecords(Collections.emptyMap()));
            spout.nextTuple();
            ((KafkaConsumer)Mockito.verify(this.consumerMock, (VerificationMode)Mockito.never())).commitSync((Map)Matchers.argThat((Matcher)new ArgumentMatcher<Map<TopicPartition, OffsetAndMetadata>>(){

                public boolean matches(Object arg) {
                    Map castArg = (Map)arg;
                    return !castArg.containsKey(KafkaSpoutMessagingGuaranteeTest.this.partition);
                }
            }));
        }
    }

    @Test
    public void testNoGuaranteeModeCommitsPolledTuples() throws Exception {
        KafkaSpoutConfig spoutConfig = SingleTopicKafkaSpoutConfiguration.createKafkaSpoutConfigBuilder((Subscription)Mockito.mock(Subscription.class), -1).setProcessingGuarantee(KafkaSpoutConfig.ProcessingGuarantee.NO_GUARANTEE).setTupleTrackingEnforced(true).build();
        try (Time.SimulatedTime time = new Time.SimulatedTime();){
            KafkaSpout<String, String> spout = SpoutWithMockedConsumerSetupHelper.setupSpout(spoutConfig, this.conf, this.contextMock, this.collectorMock, this.consumerMock, this.partition);
            Mockito.when((Object)this.consumerMock.poll(Matchers.anyLong())).thenReturn((Object)new ConsumerRecords(Collections.singletonMap(this.partition, SpoutWithMockedConsumerSetupHelper.createRecords(this.partition, 0L, 1))));
            spout.nextTuple();
            Mockito.when((Object)this.consumerMock.position(this.partition)).thenReturn((Object)1L);
            ArgumentCaptor msgIdCaptor = ArgumentCaptor.forClass(KafkaSpoutMessageId.class);
            ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock)).emit((String)Matchers.eq((Object)"test_stream"), Matchers.anyList(), msgIdCaptor.capture());
            Assert.assertThat((String)"Should have captured a message id", (Object)msgIdCaptor.getValue(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
            Time.advanceTime((long)(500L + spoutConfig.getOffsetsCommitPeriodMs()));
            spout.nextTuple();
            ((KafkaConsumer)Mockito.verify(this.consumerMock)).commitAsync((Map)this.commitCapture.capture(), (OffsetCommitCallback)Matchers.isNull(OffsetCommitCallback.class));
            CommitMetadataManager metadataManager = new CommitMetadataManager(this.contextMock, KafkaSpoutConfig.ProcessingGuarantee.NO_GUARANTEE);
            Map committedOffsets = (Map)this.commitCapture.getValue();
            Assert.assertThat((Object)((OffsetAndMetadata)committedOffsets.get(this.partition)).offset(), (Matcher)CoreMatchers.is((Object)1L));
            Assert.assertThat((Object)((OffsetAndMetadata)committedOffsets.get(this.partition)).metadata(), (Matcher)CoreMatchers.is((Object)metadataManager.getCommitMetadata()));
        }
    }
}

