/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.storm.kafka.spout.KafkaSpout;
import org.apache.storm.kafka.spout.KafkaSpoutConfig;
import org.apache.storm.kafka.spout.KafkaSpoutMessageId;
import org.apache.storm.kafka.spout.SpoutWithMockedConsumerSetupHelper;
import org.apache.storm.kafka.spout.Subscription;
import org.apache.storm.kafka.spout.builders.SingleTopicKafkaSpoutConfiguration;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.utils.Time;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class KafkaSpoutLogCompactionSupportTest {
    private final long offsetCommitPeriodMs = 2000L;
    private final TopologyContext contextMock = (TopologyContext)Mockito.mock(TopologyContext.class);
    private final SpoutOutputCollector collectorMock = (SpoutOutputCollector)Mockito.mock(SpoutOutputCollector.class);
    private final Map<String, Object> conf = new HashMap<String, Object>();
    private final TopicPartition partition = new TopicPartition("test", 1);
    private KafkaConsumer<String, String> consumerMock;
    private KafkaSpoutConfig<String, String> spoutConfig;
    @Captor
    private ArgumentCaptor<Map<TopicPartition, OffsetAndMetadata>> commitCapture;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.spoutConfig = SingleTopicKafkaSpoutConfiguration.createKafkaSpoutConfigBuilder((Subscription)Mockito.mock(Subscription.class), -1).setOffsetCommitPeriodMs(2000L).build();
        this.consumerMock = (KafkaConsumer)Mockito.mock(KafkaConsumer.class);
    }

    @Test
    public void testCommitSuccessWithOffsetVoids() {
        try (Time.SimulatedTime simulatedTime = new Time.SimulatedTime();){
            KafkaSpout<String, String> spout = SpoutWithMockedConsumerSetupHelper.setupSpout(this.spoutConfig, this.conf, this.contextMock, this.collectorMock, this.consumerMock, this.partition);
            HashMap records = new HashMap();
            ArrayList recordsForPartition = new ArrayList();
            recordsForPartition.addAll(SpoutWithMockedConsumerSetupHelper.createRecords(this.partition, 0L, 5));
            recordsForPartition.addAll(SpoutWithMockedConsumerSetupHelper.createRecords(this.partition, 8L, 2));
            records.put(this.partition, recordsForPartition);
            Mockito.when((Object)this.consumerMock.poll(org.mockito.Matchers.anyLong())).thenReturn((Object)new ConsumerRecords(records));
            for (int i = 0; i < recordsForPartition.size(); ++i) {
                spout.nextTuple();
            }
            ArgumentCaptor messageIds = ArgumentCaptor.forClass(KafkaSpoutMessageId.class);
            ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock, (VerificationMode)Mockito.times((int)recordsForPartition.size()))).emit(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyList(), messageIds.capture());
            for (KafkaSpoutMessageId messageId : messageIds.getAllValues()) {
                spout.ack((Object)messageId);
            }
            Time.advanceTime((long)2500L);
            Mockito.when((Object)this.consumerMock.poll(org.mockito.Matchers.anyLong())).thenReturn((Object)new ConsumerRecords(Collections.emptyMap()));
            spout.nextTuple();
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.consumerMock});
            ((KafkaConsumer)inOrder.verify(this.consumerMock)).commitSync((Map)this.commitCapture.capture());
            ((KafkaConsumer)inOrder.verify(this.consumerMock)).poll(org.mockito.Matchers.anyLong());
            Map commits = (Map)this.commitCapture.getValue();
            Assert.assertTrue((boolean)commits.containsKey(this.partition));
            Assert.assertEquals((long)10L, (long)((OffsetAndMetadata)commits.get(this.partition)).offset());
        }
    }

    @Test
    public void testWillSkipRetriableTuplesIfOffsetsAreCompactedAway() {
        try (Time.SimulatedTime simulatedTime = new Time.SimulatedTime();){
            TopicPartition partitionTwo = new TopicPartition("test", 2);
            KafkaSpout<String, String> spout = SpoutWithMockedConsumerSetupHelper.setupSpout(this.spoutConfig, this.conf, this.contextMock, this.collectorMock, this.consumerMock, this.partition, partitionTwo);
            List<KafkaSpoutMessageId> firstPartitionMsgIds = SpoutWithMockedConsumerSetupHelper.pollAndEmit(spout, this.consumerMock, 3, this.collectorMock, this.partition, 0, 1, 2);
            Mockito.reset((Object[])new SpoutOutputCollector[]{this.collectorMock});
            List<KafkaSpoutMessageId> secondPartitionMsgIds = SpoutWithMockedConsumerSetupHelper.pollAndEmit(spout, this.consumerMock, 3, this.collectorMock, partitionTwo, 0, 1, 2);
            Mockito.reset((Object[])new SpoutOutputCollector[]{this.collectorMock});
            for (int i = 0; i < 3; ++i) {
                spout.fail((Object)firstPartitionMsgIds.get(i));
                spout.fail((Object)secondPartitionMsgIds.get(i));
            }
            Time.advanceTime((long)50L);
            HashMap<TopicPartition, int[]> retryOffsets = new HashMap<TopicPartition, int[]>();
            retryOffsets.put(this.partition, new int[]{2});
            retryOffsets.put(partitionTwo, new int[]{0, 1, 2});
            int expectedEmits = 4;
            List<KafkaSpoutMessageId> retryMessageIds = SpoutWithMockedConsumerSetupHelper.pollAndEmit(spout, this.consumerMock, expectedEmits, this.collectorMock, retryOffsets);
            Time.advanceTime((long)2500L);
            spout.nextTuple();
            ((KafkaConsumer)Mockito.verify(this.consumerMock)).commitSync((Map)this.commitCapture.capture());
            Map committed = (Map)this.commitCapture.getValue();
            Assert.assertThat(committed.keySet(), (Matcher)CoreMatchers.is(Collections.singleton(this.partition)));
            Assert.assertThat((String)"The first partition should have committed up to the first retriable tuple that is not missing", (Object)((OffsetAndMetadata)committed.get(this.partition)).offset(), (Matcher)CoreMatchers.is((Object)2L));
            for (KafkaSpoutMessageId msgId : retryMessageIds) {
                spout.ack((Object)msgId);
            }
            Time.advanceTime((long)2500L);
            spout.nextTuple();
            ((KafkaConsumer)Mockito.verify(this.consumerMock, (VerificationMode)Mockito.times((int)2))).commitSync((Map)this.commitCapture.capture());
            committed = (Map)this.commitCapture.getValue();
            Assert.assertThat((Object)committed, (Matcher)Matchers.hasKey((Object)this.partition));
            Assert.assertThat((Object)committed, (Matcher)Matchers.hasKey((Object)partitionTwo));
            Assert.assertThat((Object)((OffsetAndMetadata)committed.get(this.partition)).offset(), (Matcher)CoreMatchers.is((Object)3L));
            Assert.assertThat((Object)((OffsetAndMetadata)committed.get(partitionTwo)).offset(), (Matcher)CoreMatchers.is((Object)3L));
        }
    }

    @Test
    public void testWillSkipRetriableTuplesIfOffsetsAreCompactedAwayWithoutAckingPendingTuples() {
        try (Time.SimulatedTime simulatedTime = new Time.SimulatedTime();){
            KafkaSpout<String, String> spout = SpoutWithMockedConsumerSetupHelper.setupSpout(this.spoutConfig, this.conf, this.contextMock, this.collectorMock, this.consumerMock, this.partition);
            List<KafkaSpoutMessageId> firstPartitionMsgIds = SpoutWithMockedConsumerSetupHelper.pollAndEmit(spout, this.consumerMock, 3, this.collectorMock, this.partition, 0, 1, 2);
            Mockito.reset((Object[])new SpoutOutputCollector[]{this.collectorMock});
            spout.fail((Object)firstPartitionMsgIds.get(0));
            spout.fail((Object)firstPartitionMsgIds.get(2));
            Time.advanceTime((long)50L);
            List<KafkaSpoutMessageId> retryMessageIds = SpoutWithMockedConsumerSetupHelper.pollAndEmit(spout, this.consumerMock, 1, this.collectorMock, this.partition, 2);
            for (KafkaSpoutMessageId msgId : retryMessageIds) {
                spout.ack((Object)msgId);
            }
            Time.advanceTime((long)2500L);
            spout.nextTuple();
            ((KafkaConsumer)Mockito.verify(this.consumerMock)).commitSync((Map)this.commitCapture.capture());
            Map committed = (Map)this.commitCapture.getValue();
            Assert.assertThat(committed.keySet(), (Matcher)CoreMatchers.is(Collections.singleton(this.partition)));
            Assert.assertThat((String)"The first partition should have committed the missing offset, but no further since the next tuple is pending", (Object)((OffsetAndMetadata)committed.get(this.partition)).offset(), (Matcher)CoreMatchers.is((Object)1L));
            spout.ack((Object)firstPartitionMsgIds.get(1));
            Time.advanceTime((long)2500L);
            spout.nextTuple();
            ((KafkaConsumer)Mockito.verify(this.consumerMock, (VerificationMode)Mockito.times((int)2))).commitSync((Map)this.commitCapture.capture());
            committed = (Map)this.commitCapture.getValue();
            Assert.assertThat(committed.keySet(), (Matcher)CoreMatchers.is(Collections.singleton(this.partition)));
            Assert.assertThat((String)"The first partition should have committed all offsets", (Object)((OffsetAndMetadata)committed.get(this.partition)).offset(), (Matcher)CoreMatchers.is((Object)3L));
        }
    }
}

