/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.storm.kafka.spout.KafkaSpout;
import org.apache.storm.kafka.spout.KafkaSpoutConfig;
import org.apache.storm.kafka.spout.KafkaSpoutMessageId;
import org.apache.storm.kafka.spout.SpoutWithMockedConsumerSetupHelper;
import org.apache.storm.kafka.spout.Subscription;
import org.apache.storm.kafka.spout.builders.SingleTopicKafkaSpoutConfiguration;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.utils.Time;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class KafkaSpoutEmitTest {
    private final long offsetCommitPeriodMs = 2000L;
    private final TopologyContext contextMock = (TopologyContext)Mockito.mock(TopologyContext.class);
    private final SpoutOutputCollector collectorMock = (SpoutOutputCollector)Mockito.mock(SpoutOutputCollector.class);
    private final Map<String, Object> conf = new HashMap<String, Object>();
    private final TopicPartition partition = new TopicPartition("test", 1);
    private KafkaConsumer<String, String> consumerMock;
    private KafkaSpoutConfig<String, String> spoutConfig;

    @Before
    public void setUp() {
        this.spoutConfig = SingleTopicKafkaSpoutConfiguration.createKafkaSpoutConfigBuilder((Subscription)Mockito.mock(Subscription.class), -1).setOffsetCommitPeriodMs(2000L).build();
        this.consumerMock = (KafkaConsumer)Mockito.mock(KafkaConsumer.class);
    }

    @Test
    public void testNextTupleEmitsAtMostOneTuple() {
        KafkaSpout<String, String> spout = SpoutWithMockedConsumerSetupHelper.setupSpout(this.spoutConfig, this.conf, this.contextMock, this.collectorMock, this.consumerMock, this.partition);
        HashMap records = new HashMap();
        records.put(this.partition, SpoutWithMockedConsumerSetupHelper.createRecords(this.partition, 0L, 10));
        Mockito.when((Object)this.consumerMock.poll(Matchers.anyLong())).thenReturn((Object)new ConsumerRecords(records));
        spout.nextTuple();
        ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock, (VerificationMode)Mockito.times((int)1))).emit(Matchers.anyString(), Matchers.anyList(), Matchers.anyObject());
    }

    @Test
    public void testNextTupleEmitsFailedMessagesEvenWhenMaxUncommittedOffsetsIsExceeded() throws IOException {
        try (Time.SimulatedTime simulatedTime = new Time.SimulatedTime();){
            KafkaSpout<String, String> spout = SpoutWithMockedConsumerSetupHelper.setupSpout(this.spoutConfig, this.conf, this.contextMock, this.collectorMock, this.consumerMock, this.partition);
            HashMap records = new HashMap();
            int numRecords = this.spoutConfig.getMaxUncommittedOffsets();
            records.put(this.partition, SpoutWithMockedConsumerSetupHelper.createRecords(this.partition, 0L, numRecords));
            Mockito.when((Object)this.consumerMock.poll(Matchers.anyLong())).thenReturn((Object)new ConsumerRecords(records));
            for (int i = 0; i < numRecords; ++i) {
                spout.nextTuple();
            }
            ArgumentCaptor messageIds = ArgumentCaptor.forClass(KafkaSpoutMessageId.class);
            ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock, (VerificationMode)Mockito.times((int)numRecords))).emit(Matchers.anyString(), Matchers.anyList(), messageIds.capture());
            for (KafkaSpoutMessageId messageId : messageIds.getAllValues()) {
                spout.fail((Object)messageId);
            }
            Mockito.reset((Object[])new SpoutOutputCollector[]{this.collectorMock});
            Time.advanceTime((long)50L);
            for (int i = 0; i < numRecords; ++i) {
                spout.nextTuple();
            }
            ArgumentCaptor retryMessageIds = ArgumentCaptor.forClass(KafkaSpoutMessageId.class);
            ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock, (VerificationMode)Mockito.times((int)numRecords))).emit(Matchers.anyString(), Matchers.anyList(), retryMessageIds.capture());
            ArrayList<Long> failedOffsets = new ArrayList<Long>();
            for (KafkaSpoutMessageId msgId : messageIds.getAllValues()) {
                failedOffsets.add(msgId.offset());
            }
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.consumerMock});
            ((KafkaConsumer)inOrder.verify(this.consumerMock)).seek(this.partition, ((Long)failedOffsets.get(0)).longValue());
            ((KafkaConsumer)inOrder.verify(this.consumerMock)).poll(Matchers.anyLong());
        }
    }

    @Test
    public void testSpoutWillSkipPartitionsAtTheMaxUncommittedOffsetsLimit() {
        try (Time.SimulatedTime simulatedTime = new Time.SimulatedTime();){
            TopicPartition partitionTwo = new TopicPartition("test", 2);
            KafkaSpout<String, String> spout = SpoutWithMockedConsumerSetupHelper.setupSpout(this.spoutConfig, this.conf, this.contextMock, this.collectorMock, this.consumerMock, this.partition, partitionTwo);
            HashMap records = new HashMap();
            records.put(this.partition, SpoutWithMockedConsumerSetupHelper.createRecords(this.partition, 0L, this.spoutConfig.getMaxUncommittedOffsets()));
            records.put(partitionTwo, SpoutWithMockedConsumerSetupHelper.createRecords(partitionTwo, 0L, this.spoutConfig.getMaxUncommittedOffsets() + 1));
            int numMessages = this.spoutConfig.getMaxUncommittedOffsets() * 2 + 1;
            Mockito.when((Object)this.consumerMock.poll(Matchers.anyLong())).thenReturn((Object)new ConsumerRecords(records));
            for (int i = 0; i < numMessages; ++i) {
                spout.nextTuple();
            }
            ArgumentCaptor messageIds = ArgumentCaptor.forClass(KafkaSpoutMessageId.class);
            ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock, (VerificationMode)Mockito.times((int)numMessages))).emit(Matchers.anyString(), Matchers.anyList(), messageIds.capture());
            Object failedMessageIdPartitionOne = null;
            for (Object msgId : messageIds.getAllValues()) {
                if (msgId.partition() != this.partition.partition()) continue;
                failedMessageIdPartitionOne = msgId;
                break;
            }
            spout.fail(failedMessageIdPartitionOne);
            KafkaSpoutMessageId failedMessageIdPartitionTwo = null;
            for (KafkaSpoutMessageId msgId : messageIds.getAllValues()) {
                if (msgId.partition() != partitionTwo.partition()) continue;
                if (failedMessageIdPartitionTwo != null) {
                    if (msgId.offset() < failedMessageIdPartitionTwo.offset()) continue;
                    failedMessageIdPartitionTwo = msgId;
                    continue;
                }
                failedMessageIdPartitionTwo = msgId;
            }
            spout.fail(failedMessageIdPartitionTwo);
            Mockito.reset((Object[])new SpoutOutputCollector[]{this.collectorMock});
            Time.advanceTime((long)50L);
            Mockito.when((Object)this.consumerMock.poll(Matchers.anyLong())).thenReturn((Object)new ConsumerRecords(Collections.singletonMap(this.partition, SpoutWithMockedConsumerSetupHelper.createRecords(this.partition, failedMessageIdPartitionOne.offset(), 1))));
            spout.nextTuple();
            ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock, (VerificationMode)Mockito.times((int)1))).emit(Matchers.anyString(), Matchers.anyList(), Matchers.anyObject());
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.consumerMock});
            ((KafkaConsumer)inOrder.verify(this.consumerMock)).seek(this.partition, failedMessageIdPartitionOne.offset());
            ((KafkaConsumer)inOrder.verify(this.consumerMock, Mockito.never())).seek((TopicPartition)Matchers.eq((Object)partitionTwo), Matchers.anyLong());
            ((KafkaConsumer)inOrder.verify(this.consumerMock)).pause(Collections.singleton(partitionTwo));
            ((KafkaConsumer)inOrder.verify(this.consumerMock)).poll(Matchers.anyLong());
            ((KafkaConsumer)inOrder.verify(this.consumerMock)).resume(Collections.singleton(partitionTwo));
            Mockito.reset((Object[])new SpoutOutputCollector[]{this.collectorMock});
            spout.nextTuple();
            ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock, (VerificationMode)Mockito.never())).emit(Matchers.anyString(), Matchers.anyList(), Matchers.anyObject());
        }
    }
}

