/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.storm.kafka.spout.DefaultRecordTranslator;
import org.apache.storm.kafka.spout.KafkaSpoutConfig;
import org.apache.storm.kafka.spout.SerializableDeserializer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class KafkaSpoutConfigTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testBasic() {
        KafkaSpoutConfig conf = KafkaSpoutConfig.builder((String)"localhost:1234", (String[])new String[]{"topic"}).build();
        Assert.assertEquals((Object)KafkaSpoutConfig.FirstPollOffsetStrategy.UNCOMMITTED_EARLIEST, (Object)conf.getFirstPollOffsetStrategy());
        Assert.assertNull((Object)conf.getConsumerGroupId());
        Assert.assertTrue((boolean)(conf.getTranslator() instanceof DefaultRecordTranslator));
        HashMap<String, Object> expected = new HashMap<String, Object>();
        expected.put("bootstrap.servers", "localhost:1234");
        expected.put("enable.auto.commit", false);
        expected.put("auto.offset.reset", "earliest");
        expected.put("key.deserializer", StringDeserializer.class);
        expected.put("value.deserializer", StringDeserializer.class);
        Assert.assertEquals(expected, (Object)conf.getKafkaProps());
        Assert.assertEquals((long)60L, (long)conf.getMetricsTimeBucketSizeInSecs());
    }

    @Test
    public void testSetEmitNullTuplesToTrue() {
        KafkaSpoutConfig conf = KafkaSpoutConfig.builder((String)"localhost:1234", (String[])new String[]{"topic"}).setEmitNullTuples(true).build();
        Assert.assertTrue((String)"Failed to set emit null tuples to true", (boolean)conf.isEmitNullTuples());
    }

    @Test
    public void testShouldNotChangeAutoOffsetResetPolicyWhenNotUsingAtLeastOnce() {
        KafkaSpoutConfig conf = KafkaSpoutConfig.builder((String)"localhost:1234", (String[])new String[]{"topic"}).setProcessingGuarantee(KafkaSpoutConfig.ProcessingGuarantee.AT_MOST_ONCE).build();
        Assert.assertThat((String)"When at-least-once is not specified, the spout should use the Kafka default auto offset reset policy", conf.getKafkaProps().get("auto.offset.reset"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testWillRespectExplicitAutoOffsetResetPolicy() {
        KafkaSpoutConfig conf = KafkaSpoutConfig.builder((String)"localhost:1234", (String[])new String[]{"topic"}).setProp("auto.offset.reset", (Object)"none").build();
        Assert.assertThat((String)"Should allow users to pick a different auto offset reset policy than the one recommended for the at-least-once processing guarantee", (Object)((String)conf.getKafkaProps().get("auto.offset.reset")), (Matcher)CoreMatchers.is((Object)"none"));
    }

    @Test
    public void testCanConfigureWithExplicitTrueBooleanAutoCommitMode() {
        KafkaSpoutConfig conf = KafkaSpoutConfig.builder((String)"localhost:1234", (String[])new String[]{"topic"}).setProp("enable.auto.commit", (Object)true).build();
        Assert.assertThat((String)"When setting enable auto commit to true explicitly the spout should use the 'none' processing guarantee", (Object)conf.getProcessingGuarantee(), (Matcher)CoreMatchers.is((Object)KafkaSpoutConfig.ProcessingGuarantee.NO_GUARANTEE));
    }

    @Test
    public void testCanConfigureWithExplicitFalseBooleanAutoCommitMode() {
        KafkaSpoutConfig conf = KafkaSpoutConfig.builder((String)"localhost:1234", (String[])new String[]{"topic"}).setProp("enable.auto.commit", (Object)false).build();
        Assert.assertThat((String)"When setting enable auto commit to false explicitly the spout should use the 'at-least-once' processing guarantee", (Object)conf.getProcessingGuarantee(), (Matcher)CoreMatchers.is((Object)KafkaSpoutConfig.ProcessingGuarantee.AT_LEAST_ONCE));
    }

    @Test
    public void testCanConfigureWithExplicitTrueStringAutoCommitMode() {
        KafkaSpoutConfig conf = KafkaSpoutConfig.builder((String)"localhost:1234", (String[])new String[]{"topic"}).setProp("enable.auto.commit", (Object)"true").build();
        Assert.assertThat((String)"When setting enable auto commit to true explicitly the spout should use the 'none' processing guarantee", (Object)conf.getProcessingGuarantee(), (Matcher)CoreMatchers.is((Object)KafkaSpoutConfig.ProcessingGuarantee.NO_GUARANTEE));
    }

    @Test
    public void testCanConfigureWithExplicitFalseStringAutoCommitMode() {
        KafkaSpoutConfig conf = KafkaSpoutConfig.builder((String)"localhost:1234", (String[])new String[]{"topic"}).setProp("enable.auto.commit", (Object)"false").build();
        Assert.assertThat((String)"When setting enable auto commit explicitly to false the spout should use the 'at-least-once' processing guarantee", (Object)conf.getProcessingGuarantee(), (Matcher)CoreMatchers.is((Object)KafkaSpoutConfig.ProcessingGuarantee.AT_LEAST_ONCE));
    }

    @Test
    public void testCanGetKeyDeserializerWhenUsingDefaultBuilder() {
        KafkaSpoutConfig conf = KafkaSpoutConfig.builder((String)"localhost:1234", (String[])new String[]{"topic"}).build();
        Assert.assertThat((String)"When using the default builder methods, the key deserializer should default to StringDeserializer", (Object)conf.getKeyDeserializer(), (Matcher)CoreMatchers.instanceOf(StringDeserializer.class));
    }

    @Test
    public void testCanGetValueDeserializerWhenUsingDefaultBuilder() {
        KafkaSpoutConfig conf = KafkaSpoutConfig.builder((String)"localhost:1234", (String[])new String[]{"topic"}).build();
        Assert.assertThat((String)"When using the default builder methods, the value deserializer should default to StringDeserializer", (Object)conf.getValueDeserializer(), (Matcher)CoreMatchers.instanceOf(StringDeserializer.class));
    }

    @Test
    public void testCanOverrideDeprecatedDeserializerClassWithKafkaProps() {
        KafkaSpoutConfig conf = KafkaSpoutConfig.builder((String)"localhost:1234", (String[])new String[]{"topic"}).setKey(StringDeserializer.class).setValue(StringDeserializer.class).setProp("key.deserializer", ByteArrayDeserializer.class).setProp("value.deserializer", ByteArrayDeserializer.class).build();
        Assert.assertThat((String)"The last set key deserializer should be used, regardless of how it is set", conf.getKafkaProps().get("key.deserializer"), (Matcher)CoreMatchers.equalTo(ByteArrayDeserializer.class));
        Assert.assertThat((String)"The last set value deserializer should be used, regardless of how it is set", conf.getKafkaProps().get("value.deserializer"), (Matcher)CoreMatchers.equalTo(ByteArrayDeserializer.class));
    }

    @Test
    public void testCanOverrideDeprecatedDeserializerInstanceWithKafkaProps() {
        KafkaSpoutConfig conf = KafkaSpoutConfig.builder((String)"localhost:1234", (String[])new String[]{"topic"}).setKey((SerializableDeserializer)new SerializableStringDeserializer()).setValue((SerializableDeserializer)new SerializableStringDeserializer()).setProp("key.deserializer", ByteArrayDeserializer.class).setProp("value.deserializer", ByteArrayDeserializer.class).build();
        Assert.assertThat((String)"The last set key deserializer should be used, regardless of how it is set", conf.getKafkaProps().get("key.deserializer"), (Matcher)CoreMatchers.equalTo(ByteArrayDeserializer.class));
        Assert.assertThat((String)"The last set value deserializer should be used, regardless of how it is set", conf.getKafkaProps().get("value.deserializer"), (Matcher)CoreMatchers.equalTo(ByteArrayDeserializer.class));
    }

    @Test
    public void testCanOverrideKafkaPropsWithDeprecatedDeserializerSetter() {
        KafkaSpoutConfig conf = KafkaSpoutConfig.builder((String)"localhost:1234", (String[])new String[]{"topic"}).setProp("key.deserializer", ByteArrayDeserializer.class).setProp("value.deserializer", ByteArrayDeserializer.class).setKey((SerializableDeserializer)new SerializableStringDeserializer()).setValue((SerializableDeserializer)new SerializableStringDeserializer()).build();
        Assert.assertThat((String)"The last set key deserializer should be used, regardless of how it is set", conf.getKafkaProps().get("key.deserializer"), (Matcher)CoreMatchers.equalTo(SerializableStringDeserializer.class));
        Assert.assertThat((String)"The last set value deserializer should be used, regardless of how it is set", conf.getKafkaProps().get("value.deserializer"), (Matcher)CoreMatchers.equalTo(SerializableStringDeserializer.class));
    }

    @Test
    public void testCanMixOldAndNewDeserializerSetter() {
        KafkaSpoutConfig conf = KafkaSpoutConfig.builder((String)"localhost:1234", (String[])new String[]{"topic"}).setProp("value.deserializer", ByteArrayDeserializer.class).setKey((SerializableDeserializer)new SerializableStringDeserializer()).setProp("key.deserializer", ByteArrayDeserializer.class).setValue((SerializableDeserializer)new SerializableStringDeserializer()).build();
        Assert.assertThat((String)"The last set key deserializer should be used, regardless of how it is set", conf.getKafkaProps().get("key.deserializer"), (Matcher)CoreMatchers.equalTo(ByteArrayDeserializer.class));
        Assert.assertThat((String)"The last set value deserializer should be used, regardless of how it is set", conf.getKafkaProps().get("value.deserializer"), (Matcher)CoreMatchers.equalTo(SerializableStringDeserializer.class));
    }

    @Test
    public void testMetricsTimeBucketSizeInSecs() {
        KafkaSpoutConfig conf = KafkaSpoutConfig.builder((String)"localhost:1234", (String[])new String[]{"topic"}).setMetricsTimeBucketSizeInSecs(100).build();
        Assert.assertEquals((long)100L, (long)conf.getMetricsTimeBucketSizeInSecs());
    }

    private static class SerializableStringDeserializer
    implements SerializableDeserializer {
        private final StringDeserializer delegate = new StringDeserializer();

        private SerializableStringDeserializer() {
        }

        public void configure(Map configs, boolean isKey) {
            this.delegate.configure(configs, isKey);
        }

        public Object deserialize(String topic, byte[] data) {
            return this.delegate.deserialize(topic, data);
        }

        public void close() {
            this.delegate.close();
        }
    }
}

