/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.storm.kafka.KafkaUnitRule;
import org.apache.storm.kafka.spout.KafkaSpout;
import org.apache.storm.kafka.spout.KafkaSpoutConfig;
import org.apache.storm.kafka.spout.SingleTopicKafkaUnitSetupHelper;
import org.apache.storm.kafka.spout.internal.KafkaConsumerFactory;
import org.apache.storm.kafka.spout.internal.KafkaConsumerFactoryDefault;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.tuple.Values;
import org.apache.storm.utils.Time;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public abstract class KafkaSpoutAbstractTest {
    @Rule
    public KafkaUnitRule kafkaUnitRule = new KafkaUnitRule();
    final TopologyContext topologyContext = (TopologyContext)Mockito.mock(TopologyContext.class);
    final Map<String, Object> conf = new HashMap<String, Object>();
    final SpoutOutputCollector collectorMock = (SpoutOutputCollector)Mockito.mock(SpoutOutputCollector.class);
    final long commitOffsetPeriodMs;
    KafkaConsumer<String, String> consumerSpy;
    KafkaSpout<String, String> spout;
    @Captor
    ArgumentCaptor<Map<TopicPartition, OffsetAndMetadata>> commitCapture;
    private Time.SimulatedTime simulatedTime;
    private KafkaSpoutConfig<String, String> spoutConfig;

    protected KafkaSpoutAbstractTest(long commitOffsetPeriodMs) {
        this.commitOffsetPeriodMs = commitOffsetPeriodMs;
    }

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.spoutConfig = this.createSpoutConfig();
        this.consumerSpy = this.createConsumerSpy();
        this.spout = new KafkaSpout(this.spoutConfig, this.createConsumerFactory());
        this.simulatedTime = new Time.SimulatedTime();
    }

    private KafkaConsumerFactory<String, String> createConsumerFactory() {
        return new KafkaConsumerFactory<String, String>(){

            public KafkaConsumer<String, String> createConsumer(KafkaSpoutConfig<String, String> kafkaSpoutConfig) {
                return KafkaSpoutAbstractTest.this.consumerSpy;
            }
        };
    }

    KafkaConsumer<String, String> createConsumerSpy() {
        return (KafkaConsumer)Mockito.spy((Object)new KafkaConsumerFactoryDefault().createConsumer(this.spoutConfig));
    }

    @After
    public void tearDown() throws Exception {
        this.simulatedTime.close();
    }

    abstract KafkaSpoutConfig<String, String> createSpoutConfig();

    void prepareSpout(int messageCount) throws Exception {
        SingleTopicKafkaUnitSetupHelper.populateTopicData(this.kafkaUnitRule.getKafkaUnit(), "test", messageCount);
        SingleTopicKafkaUnitSetupHelper.initializeSpout(this.spout, this.conf, this.topologyContext, this.collectorMock);
    }

    ArgumentCaptor<Object> nextTuple_verifyEmitted_ack_resetCollector(int offset) {
        this.spout.nextTuple();
        ArgumentCaptor<Object> messageId = this.verifyMessageEmitted(offset);
        this.spout.ack(messageId.getValue());
        Mockito.reset((Object[])new SpoutOutputCollector[]{this.collectorMock});
        return messageId;
    }

    ArgumentCaptor<Object> verifyMessageEmitted(int offset) {
        ArgumentCaptor messageId = ArgumentCaptor.forClass(Object.class);
        ((SpoutOutputCollector)Mockito.verify((Object)this.collectorMock)).emit((String)Matchers.eq((Object)"test_stream"), (List)Matchers.eq((Object)new Values(new Object[]{"test", Integer.toString(offset), Integer.toString(offset)})), messageId.capture());
        return messageId;
    }

    void commitAndVerifyAllMessagesCommitted(long msgCount) {
        Time.advanceTime((long)(this.commitOffsetPeriodMs + 500L));
        this.spout.nextTuple();
        this.verifyAllMessagesCommitted(msgCount);
    }

    void verifyAllMessagesCommitted(long messageCount) {
        ((KafkaConsumer)Mockito.verify(this.consumerSpy)).commitSync((Map)this.commitCapture.capture());
        Map commits = (Map)this.commitCapture.getValue();
        MatcherAssert.assertThat((String)"Expected commits for only one topic partition", (Object)commits.entrySet().size(), (Matcher)CoreMatchers.is((Object)1));
        OffsetAndMetadata offset = (OffsetAndMetadata)commits.entrySet().iterator().next().getValue();
        MatcherAssert.assertThat((String)"Expected committed offset to cover all emitted messages", (Object)offset.offset(), (Matcher)CoreMatchers.is((Object)messageCount));
        Mockito.reset((Object[])new KafkaConsumer[]{this.consumerSpy});
    }
}

