/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.storm.kafka.spout.ByTopicRecordTranslator;
import org.apache.storm.kafka.spout.Func;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;
import org.junit.Assert;
import org.junit.Test;

public class ByTopicRecordTranslatorTest {
    public static Func<ConsumerRecord<String, String>, List<Object>> JUST_KEY_FUNC = new Func<ConsumerRecord<String, String>, List<Object>>(){

        public List<Object> apply(ConsumerRecord<String, String> record) {
            return new Values(new Object[]{record.key()});
        }
    };
    public static Func<ConsumerRecord<String, String>, List<Object>> JUST_VALUE_FUNC = new Func<ConsumerRecord<String, String>, List<Object>>(){

        public List<Object> apply(ConsumerRecord<String, String> record) {
            return new Values(new Object[]{record.value()});
        }
    };
    public static Func<ConsumerRecord<String, String>, List<Object>> KEY_VALUE_FUNC = new Func<ConsumerRecord<String, String>, List<Object>>(){

        public List<Object> apply(ConsumerRecord<String, String> record) {
            return new Values(new Object[]{record.key(), record.value()});
        }
    };

    @Test
    public void testBasic() {
        ByTopicRecordTranslator trans = new ByTopicRecordTranslator(JUST_KEY_FUNC, new Fields(new String[]{"key"}));
        trans.forTopic("TOPIC 1", JUST_VALUE_FUNC, new Fields(new String[]{"value"}), "value-stream");
        trans.forTopic("TOPIC 2", KEY_VALUE_FUNC, new Fields(new String[]{"key", "value"}), "key-value-stream");
        HashSet<String> expectedStreams = new HashSet<String>();
        expectedStreams.add("default");
        expectedStreams.add("value-stream");
        expectedStreams.add("key-value-stream");
        Assert.assertEquals(expectedStreams, new HashSet(trans.streams()));
        ConsumerRecord cr1 = new ConsumerRecord("TOPIC OTHER", 100, 100L, (Object)"THE KEY", (Object)"THE VALUE");
        Assert.assertEquals((Object)new Fields(new String[]{"key"}), (Object)trans.getFieldsFor("default"));
        Assert.assertEquals(Arrays.asList("THE KEY"), (Object)trans.apply(cr1));
        ConsumerRecord cr2 = new ConsumerRecord("TOPIC 1", 100, 100L, (Object)"THE KEY", (Object)"THE VALUE");
        Assert.assertEquals((Object)new Fields(new String[]{"value"}), (Object)trans.getFieldsFor("value-stream"));
        Assert.assertEquals(Arrays.asList("THE VALUE"), (Object)trans.apply(cr2));
        ConsumerRecord cr3 = new ConsumerRecord("TOPIC 2", 100, 100L, (Object)"THE KEY", (Object)"THE VALUE");
        Assert.assertEquals((Object)new Fields(new String[]{"key", "value"}), (Object)trans.getFieldsFor("key-value-stream"));
        Assert.assertEquals(Arrays.asList("THE KEY", "THE VALUE"), (Object)trans.apply(cr3));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFieldCollision() {
        ByTopicRecordTranslator trans = new ByTopicRecordTranslator(JUST_KEY_FUNC, new Fields(new String[]{"key"}));
        trans.forTopic("foo", JUST_VALUE_FUNC, new Fields(new String[]{"value"}));
    }

    @Test(expected=IllegalStateException.class)
    public void testTopicCollision() {
        ByTopicRecordTranslator trans = new ByTopicRecordTranslator(JUST_KEY_FUNC, new Fields(new String[]{"key"}));
        trans.forTopic("foo", JUST_VALUE_FUNC, new Fields(new String[]{"value"}), "foo1");
        trans.forTopic("foo", KEY_VALUE_FUNC, new Fields(new String[]{"key", "value"}), "foo2");
    }
}

