/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.bolt;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.storm.Testing;
import org.apache.storm.kafka.bolt.KafkaBolt;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.testing.MkTupleParam;
import org.apache.storm.tuple.Tuple;
import org.hamcrest.Matcher;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaBoltTest {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaBoltTest.class);

    @Test
    public void testSimple() {
        final KafkaProducer producer = (KafkaProducer)Mockito.mock(KafkaProducer.class);
        Mockito.when((Object)producer.send((ProducerRecord)Matchers.any(), (Callback)Matchers.any())).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Callback c = (Callback)invocation.getArguments()[1];
                c.onCompletion(null, null);
                return null;
            }
        });
        KafkaBolt<String, String> bolt = new KafkaBolt<String, String>(){

            protected KafkaProducer<String, String> mkProducer(Properties props) {
                return producer;
            }
        };
        bolt.withTopicSelector("MY_TOPIC");
        OutputCollector collector = (OutputCollector)Mockito.mock(OutputCollector.class);
        TopologyContext context = (TopologyContext)Mockito.mock(TopologyContext.class);
        HashMap conf = new HashMap();
        bolt.prepare(conf, context, collector);
        MkTupleParam param = new MkTupleParam();
        param.setFields(new String[]{"key", "message"});
        Tuple testTuple = Testing.testTuple(Arrays.asList("KEY", "VALUE"), (MkTupleParam)param);
        bolt.execute(testTuple);
        ((KafkaProducer)Mockito.verify((Object)producer)).send((ProducerRecord)Matchers.argThat((Matcher)new ArgumentMatcher<ProducerRecord<String, String>>(){

            public boolean matches(Object argument) {
                LOG.info("GOT {} ->", argument);
                ProducerRecord arg = (ProducerRecord)argument;
                LOG.info("  {} {} {}", new Object[]{arg.topic(), arg.key(), arg.value()});
                return "MY_TOPIC".equals(arg.topic()) && "KEY".equals(arg.key()) && "VALUE".equals(arg.value());
            }
        }), (Callback)Matchers.any(Callback.class));
        ((OutputCollector)Mockito.verify((Object)collector)).ack(testTuple);
    }
}

