/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kafka.admin.AdminUtils;
import kafka.admin.RackAwareMode;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.MockTime;
import kafka.utils.TestUtils;
import kafka.utils.Time;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaUnit {
    private KafkaServer kafkaServer;
    private EmbeddedZookeeper zkServer;
    private ZkUtils zkUtils;
    private KafkaProducer<String, String> producer;
    private static final String ZK_HOST = "127.0.0.1";
    private static final String KAFKA_HOST = "127.0.0.1";
    private static final int KAFKA_PORT = 9092;

    public void setUp() throws IOException {
        this.zkServer = new EmbeddedZookeeper();
        String zkConnect = "127.0.0.1:" + this.zkServer.port();
        ZkClient zkClient = new ZkClient(zkConnect, 30000, 30000, (ZkSerializer)ZKStringSerializer$.MODULE$);
        this.zkUtils = ZkUtils.apply((ZkClient)zkClient, (boolean)false);
        Properties brokerProps = new Properties();
        brokerProps.setProperty("zookeeper.connect", zkConnect);
        brokerProps.setProperty("broker.id", "0");
        brokerProps.setProperty("log.dirs", Files.createTempDirectory("kafka-", new FileAttribute[0]).toAbsolutePath().toString());
        brokerProps.setProperty("listeners", String.format("PLAINTEXT://%s:%d", "127.0.0.1", 9092));
        KafkaConfig config = new KafkaConfig((Map)brokerProps);
        MockTime mock = new MockTime();
        this.kafkaServer = TestUtils.createServer((KafkaConfig)config, (Time)mock);
        this.createProducer();
    }

    public void tearDown() {
        this.closeProducer();
        this.kafkaServer.shutdown();
        this.zkUtils.close();
        this.zkServer.shutdown();
    }

    public void createTopic(String topicName) {
        AdminUtils.createTopic((ZkUtils)this.zkUtils, (String)topicName, (int)1, (int)1, (Properties)new Properties(), (RackAwareMode)RackAwareMode.Disabled$.MODULE$);
    }

    public int getKafkaPort() {
        return 9092;
    }

    private void createProducer() {
        Properties producerProps = new Properties();
        producerProps.setProperty("bootstrap.servers", "127.0.0.1:9092");
        producerProps.setProperty("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        producerProps.setProperty("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.producer = new KafkaProducer(producerProps);
    }

    public void createProducer(Serializer keySerializer, Serializer valueSerializer) {
        Properties producerProps = new Properties();
        producerProps.setProperty("bootstrap.servers", "127.0.0.1:9092");
        this.producer = new KafkaProducer(producerProps, keySerializer, valueSerializer);
    }

    public void sendMessage(ProducerRecord producerRecord) throws InterruptedException, ExecutionException, TimeoutException {
        this.producer.send(producerRecord).get(10L, TimeUnit.SECONDS);
    }

    private void closeProducer() {
        this.producer.close();
    }
}

