/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.solr.topology;

import java.io.IOException;
import java.util.Map;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.storm.Config;
import org.apache.storm.LocalCluster;
import org.apache.storm.StormSubmitter;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.solr.config.SolrCommitStrategy;
import org.apache.storm.solr.config.SolrConfig;

public abstract class SolrTopology {
    protected static String COLLECTION = "gettingstarted";

    public void run(String[] args) throws Exception {
        StormTopology topology = this.getTopology();
        Config config = this.getConfig();
        if (args.length == 0) {
            this.submitTopologyLocalCluster(topology, config);
        } else {
            this.submitTopologyRemoteCluster(args[0], topology, config);
        }
    }

    protected abstract StormTopology getTopology() throws IOException;

    protected void submitTopologyRemoteCluster(String arg, StormTopology topology, Config config) throws Exception {
        StormSubmitter.submitTopology((String)arg, (Map)config, (StormTopology)topology);
    }

    protected void submitTopologyLocalCluster(StormTopology topology, Config config) throws InterruptedException {
        LocalCluster cluster = new LocalCluster();
        cluster.submitTopology("test", (Map)config, topology);
        Thread.sleep(10000L);
        System.out.println("Killing topology per client's request");
        cluster.killTopology("test");
        cluster.shutdown();
        System.exit(0);
    }

    protected Config getConfig() {
        Config config = new Config();
        config.setDebug(true);
        return config;
    }

    protected SolrCommitStrategy getSolrCommitStgy() {
        return null;
    }

    protected static SolrConfig getSolrConfig() {
        String zkHostString = "127.0.0.1:9983";
        return new SolrConfig(zkHostString);
    }

    protected static SolrClient getSolrClient() {
        String zkHostString = "127.0.0.1:9983";
        return new CloudSolrClient(zkHostString);
    }
}

