/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.solr.topology;

import java.io.IOException;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.solr.bolt.SolrUpdateBolt;
import org.apache.storm.solr.mapper.SolrJsonMapper;
import org.apache.storm.solr.mapper.SolrMapper;
import org.apache.storm.solr.spout.SolrJsonSpout;
import org.apache.storm.solr.topology.SolrTopology;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.topology.TopologyBuilder;

public class SolrJsonTopology
extends SolrTopology {
    public static void main(String[] args) throws Exception {
        SolrJsonTopology solrJsonTopology = new SolrJsonTopology();
        solrJsonTopology.run(args);
    }

    protected SolrMapper getSolrMapper() throws IOException {
        String jsonTupleField = "JSON";
        return new SolrJsonMapper.Builder(COLLECTION, "JSON").build();
    }

    @Override
    protected StormTopology getTopology() throws IOException {
        TopologyBuilder builder = new TopologyBuilder();
        builder.setSpout("SolrJsonSpout", (IRichSpout)new SolrJsonSpout());
        builder.setBolt("SolrUpdateBolt", (IRichBolt)new SolrUpdateBolt(SolrJsonTopology.getSolrConfig(), this.getSolrMapper(), this.getSolrCommitStgy())).shuffleGrouping("SolrJsonSpout");
        return builder.createTopology();
    }
}

