/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.solr.topology;

import java.io.IOException;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.solr.bolt.SolrUpdateBolt;
import org.apache.storm.solr.config.CountBasedCommit;
import org.apache.storm.solr.config.SolrCommitStrategy;
import org.apache.storm.solr.mapper.SolrFieldsMapper;
import org.apache.storm.solr.mapper.SolrMapper;
import org.apache.storm.solr.schema.builder.RestJsonSchemaBuilder;
import org.apache.storm.solr.schema.builder.SchemaBuilder;
import org.apache.storm.solr.spout.SolrFieldsSpout;
import org.apache.storm.solr.topology.SolrTopology;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.topology.TopologyBuilder;

public class SolrFieldsTopology
extends SolrTopology {
    public static void main(String[] args) throws Exception {
        SolrFieldsTopology solrFieldsTopology = new SolrFieldsTopology();
        solrFieldsTopology.run(args);
    }

    protected SolrMapper getSolrMapper() throws IOException {
        return new SolrFieldsMapper.Builder((SchemaBuilder)new RestJsonSchemaBuilder("localhost", "8983", COLLECTION), COLLECTION).setMultiValueFieldToken("%").build();
    }

    @Override
    protected SolrCommitStrategy getSolrCommitStgy() {
        return new CountBasedCommit(2);
    }

    @Override
    protected StormTopology getTopology() throws IOException {
        TopologyBuilder builder = new TopologyBuilder();
        builder.setSpout("SolrFieldsSpout", (IRichSpout)new SolrFieldsSpout());
        builder.setBolt("SolrUpdateBolt", (IRichBolt)new SolrUpdateBolt(SolrFieldsTopology.getSolrConfig(), this.getSolrMapper(), this.getSolrCommitStgy())).shuffleGrouping("SolrFieldsSpout");
        return builder.createTopology();
    }
}

