/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.solr.spout;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.storm.solr.util.TestUtil;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseRichSpout;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;

public class SolrJsonSpout
extends BaseRichSpout {
    private SpoutOutputCollector collector;
    private static final List<Values> listValues = Lists.newArrayList((Object[])new Values[]{SolrJsonSpout.getJsonValues("1"), SolrJsonSpout.getJsonValues("2"), SolrJsonSpout.getJsonValues("3"), SolrJsonSpout.getPojoValues("1"), SolrJsonSpout.getPojoValues("2")});

    public void open(Map conf, TopologyContext context, SpoutOutputCollector collector) {
        this.collector = collector;
    }

    public void nextTuple() {
        Random rand = new Random();
        Values values = listValues.get(rand.nextInt(listValues.size()));
        this.collector.emit((List)values);
        Thread.yield();
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(this.getOutputFields());
    }

    public Fields getOutputFields() {
        return new Fields(new String[]{"JSON"});
    }

    public void close() {
        super.close();
    }

    private static Values getJsonValues(String suf) {
        String suffix = "_json_test_val_" + suf;
        return new Values(new Object[]{new JsonSchema(suffix).toJson()});
    }

    private static Values getPojoValues(String suf) {
        String suffix = "_json_test_val_" + suf;
        return new Values(new Object[]{new JsonSchema(suffix)});
    }

    public static class JsonSchema {
        private String id;
        private String date;
        private String dc_title;
        private static final Gson gson = new Gson();

        public JsonSchema(String suffix) {
            this.id = "id" + suffix;
            this.date = TestUtil.getDate();
            this.dc_title = "dc_title" + suffix;
        }

        public JsonSchema(String id, String date, String dc_title) {
            this.id = id;
            this.date = date;
            this.dc_title = dc_title;
        }

        public JsonSchema(JsonSchema jsonSchema) {
            this.id = jsonSchema.id;
            this.date = jsonSchema.date;
            this.dc_title = jsonSchema.dc_title;
        }

        public String toJson() {
            String json = gson.toJson((Object)this);
            System.out.println(json);
            return json;
        }

        public static JsonSchema fromJson(String jsonStr) {
            return new JsonSchema((JsonSchema)gson.fromJson(jsonStr, JsonSchema.class));
        }
    }
}

