/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.solr.spout;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.storm.solr.util.TestUtil;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseRichSpout;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;

public class SolrFieldsSpout
extends BaseRichSpout {
    private SpoutOutputCollector collector;
    public static final List<Values> listValues = Lists.newArrayList((Object[])new Values[]{SolrFieldsSpout.getValues("1"), SolrFieldsSpout.getValues("2"), SolrFieldsSpout.getValues("3")});

    private static Values getValues(String suf) {
        String suffix = "_fields_test_val_" + suf;
        return new Values(new Object[]{"id" + suffix, TestUtil.getDate(), "dc_title" + suffix, "Hugo%Miguel%Louro" + suffix, "dynamic_field" + suffix + "_txt", "non_matching_field" + suffix});
    }

    public void open(Map conf, TopologyContext context, SpoutOutputCollector collector) {
        this.collector = collector;
    }

    public void nextTuple() {
        Random rand = new Random();
        Values values = listValues.get(rand.nextInt(listValues.size()));
        this.collector.emit((List)values);
        Thread.yield();
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(this.getOutputFields());
    }

    public Fields getOutputFields() {
        return new Fields(new String[]{"id", "date", "dc_title", "author", "dynamic_field_txt", "non_matching_field"});
    }

    public void close() {
        super.close();
    }
}

