/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.trident;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.lang.Validate;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.storm.kafka.trident.mapper.TridentTupleToKafkaMapper;
import org.apache.storm.kafka.trident.selector.KafkaTopicSelector;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.topology.FailedException;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.state.State;
import org.apache.storm.trident.tuple.TridentTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TridentKafkaState
implements State {
    private static final Logger LOG = LoggerFactory.getLogger(TridentKafkaState.class);
    private KafkaProducer producer;
    private OutputCollector collector;
    private TridentTupleToKafkaMapper mapper;
    private KafkaTopicSelector topicSelector;

    public TridentKafkaState withTridentTupleToKafkaMapper(TridentTupleToKafkaMapper mapper) {
        this.mapper = mapper;
        return this;
    }

    public TridentKafkaState withKafkaTopicSelector(KafkaTopicSelector selector) {
        this.topicSelector = selector;
        return this;
    }

    public void beginCommit(Long txid) {
        LOG.debug("beginCommit is Noop.");
    }

    public void commit(Long txid) {
        LOG.debug("commit is Noop.");
    }

    public void prepare(Properties options) {
        Validate.notNull((Object)this.mapper, (String)"mapper can not be null");
        Validate.notNull((Object)this.topicSelector, (String)"topicSelector can not be null");
        this.producer = new KafkaProducer(options);
    }

    public void updateState(List<TridentTuple> tuples, TridentCollector collector) {
        String topic = null;
        for (TridentTuple tuple : tuples) {
            try {
                topic = this.topicSelector.getTopic(tuple);
                if (topic != null) {
                    Future result = this.producer.send(new ProducerRecord(topic, this.mapper.getKeyFromTuple(tuple), this.mapper.getMessageFromTuple(tuple)));
                    try {
                        result.get();
                        continue;
                    }
                    catch (ExecutionException e) {
                        String errorMsg = "Could not retrieve result for message with key = " + this.mapper.getKeyFromTuple(tuple) + " from topic = " + topic;
                        LOG.error(errorMsg, (Throwable)e);
                        throw new FailedException(errorMsg, (Throwable)e);
                    }
                }
                LOG.warn("skipping key = " + this.mapper.getKeyFromTuple(tuple) + ", topic selector returned null.");
            }
            catch (Exception ex) {
                String errorMsg = "Could not send message with key = " + this.mapper.getKeyFromTuple(tuple) + " to topic = " + topic;
                LOG.warn(errorMsg, (Throwable)ex);
                throw new FailedException(errorMsg, (Throwable)ex);
            }
        }
    }
}

