/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.storm.kafka.DynamicPartitionConnections;
import org.apache.storm.kafka.FailedFetchException;
import org.apache.storm.kafka.KafkaUtils;
import org.apache.storm.kafka.Partition;
import org.apache.storm.kafka.PartitionCoordinator;
import org.apache.storm.kafka.PartitionManager;
import org.apache.storm.kafka.SpoutConfig;
import org.apache.storm.kafka.StaticCoordinator;
import org.apache.storm.kafka.StaticHosts;
import org.apache.storm.kafka.ZkCoordinator;
import org.apache.storm.kafka.ZkState;
import org.apache.storm.metric.api.IMetric;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseRichSpout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSpout
extends BaseRichSpout {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaSpout.class);
    SpoutConfig _spoutConfig;
    SpoutOutputCollector _collector;
    PartitionCoordinator _coordinator;
    DynamicPartitionConnections _connections;
    ZkState _state;
    long _lastUpdateMs = 0L;
    int _currPartitionIndex = 0;

    public KafkaSpout(SpoutConfig spoutConf) {
        this._spoutConfig = spoutConf;
    }

    public void open(Map conf, TopologyContext context, SpoutOutputCollector collector) {
        Integer zkPort;
        this._collector = collector;
        String topologyInstanceId = context.getStormId();
        HashMap<String, Object> stateConf = new HashMap<String, Object>(conf);
        List zkServers = this._spoutConfig.zkServers;
        if (zkServers == null) {
            zkServers = (List)conf.get("storm.zookeeper.servers");
        }
        if ((zkPort = this._spoutConfig.zkPort) == null) {
            zkPort = ((Number)conf.get("storm.zookeeper.port")).intValue();
        }
        stateConf.put("transactional.zookeeper.servers", zkServers);
        stateConf.put("transactional.zookeeper.port", zkPort);
        stateConf.put("transactional.zookeeper.root", this._spoutConfig.zkRoot);
        this._state = new ZkState(stateConf);
        this._connections = new DynamicPartitionConnections(this._spoutConfig, KafkaUtils.makeBrokerReader(conf, this._spoutConfig));
        int totalTasks = context.getComponentTasks(context.getThisComponentId()).size();
        this._coordinator = this._spoutConfig.hosts instanceof StaticHosts ? new StaticCoordinator(this._connections, conf, this._spoutConfig, this._state, context.getThisTaskIndex(), totalTasks, topologyInstanceId) : new ZkCoordinator(this._connections, conf, this._spoutConfig, this._state, context.getThisTaskIndex(), totalTasks, topologyInstanceId);
        context.registerMetric("kafkaOffset", new IMetric(){
            KafkaUtils.KafkaOffsetMetric _kafkaOffsetMetric;
            {
                this._kafkaOffsetMetric = new KafkaUtils.KafkaOffsetMetric(KafkaSpout.this._connections);
            }

            public Object getValueAndReset() {
                List<PartitionManager> pms = KafkaSpout.this._coordinator.getMyManagedPartitions();
                HashSet<Partition> latestPartitions = new HashSet<Partition>();
                for (PartitionManager pm : pms) {
                    latestPartitions.add(pm.getPartition());
                }
                this._kafkaOffsetMetric.refreshPartitions(latestPartitions);
                for (PartitionManager pm : pms) {
                    this._kafkaOffsetMetric.setOffsetData(pm.getPartition(), pm.getOffsetData());
                }
                return this._kafkaOffsetMetric.getValueAndReset();
            }
        }, this._spoutConfig.metricsTimeBucketSizeInSecs);
        context.registerMetric("kafkaPartition", new IMetric(){

            public Object getValueAndReset() {
                List<PartitionManager> pms = KafkaSpout.this._coordinator.getMyManagedPartitions();
                HashMap concatMetricsDataMaps = new HashMap();
                for (PartitionManager pm : pms) {
                    concatMetricsDataMaps.putAll(pm.getMetricsDataMap());
                }
                return concatMetricsDataMaps;
            }
        }, this._spoutConfig.metricsTimeBucketSizeInSecs);
    }

    public void close() {
        this._state.close();
    }

    public void nextTuple() {
        long diffWithNow;
        List<PartitionManager> managers = this._coordinator.getMyManagedPartitions();
        for (int i = 0; i < managers.size(); ++i) {
            try {
                this._currPartitionIndex %= managers.size();
                EmitState state = managers.get(this._currPartitionIndex).next(this._collector);
                if (state != EmitState.EMITTED_MORE_LEFT) {
                    this._currPartitionIndex = (this._currPartitionIndex + 1) % managers.size();
                }
                if (state == EmitState.NO_EMITTED) continue;
                break;
            }
            catch (FailedFetchException e) {
                LOG.warn("Fetch failed", (Throwable)e);
                this._coordinator.refresh();
            }
        }
        if ((diffWithNow = System.currentTimeMillis() - this._lastUpdateMs) > this._spoutConfig.stateUpdateIntervalMs || diffWithNow < 0L) {
            this.commit();
        }
    }

    private PartitionManager getManagerForPartition(int partition) {
        for (PartitionManager partitionManager : this._coordinator.getMyManagedPartitions()) {
            if (partitionManager.getPartition().partition != partition) continue;
            return partitionManager;
        }
        return null;
    }

    public void ack(Object msgId) {
        PartitionManager.KafkaMessageId id = (PartitionManager.KafkaMessageId)msgId;
        PartitionManager m = this._coordinator.getManager(id.partition);
        if (m != null) {
            m.ack(id.offset);
        } else {
            PartitionManager newManager = this.getManagerForPartition(id.partition.partition);
            if (newManager != null) {
                newManager.ack(id.offset);
            }
        }
    }

    public void fail(Object msgId) {
        PartitionManager.KafkaMessageId id = (PartitionManager.KafkaMessageId)msgId;
        PartitionManager m = this._coordinator.getManager(id.partition);
        if (m != null) {
            m.fail(id.offset);
        } else {
            PartitionManager newManager = this.getManagerForPartition(id.partition.partition);
            if (newManager != null) {
                newManager.fail(id.offset);
            }
        }
    }

    public void deactivate() {
        this.commit();
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        if (!Strings.isNullOrEmpty((String)this._spoutConfig.outputStreamId)) {
            declarer.declareStream(this._spoutConfig.outputStreamId, this._spoutConfig.scheme.getOutputFields());
        } else {
            declarer.declare(this._spoutConfig.scheme.getOutputFields());
        }
    }

    private void commit() {
        this._lastUpdateMs = System.currentTimeMillis();
        for (PartitionManager manager : this._coordinator.getMyManagedPartitions()) {
            manager.commit();
        }
    }

    static enum EmitState {
        EMITTED_MORE_LEFT,
        EMITTED_END,
        NO_EMITTED;

    }
}

