/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.mqtt.ssl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.storm.mqtt.ssl.KeyStoreLoader;

public class DefaultKeyStoreLoader
implements KeyStoreLoader {
    private String ksFile = null;
    private String tsFile = null;
    private String keyStorePassword = "";
    private String trustStorePassword = "";
    private String keyPassword = "";

    public DefaultKeyStoreLoader(String keystore) {
        this.ksFile = keystore;
    }

    public DefaultKeyStoreLoader(String keystore, String truststore) {
        this.ksFile = keystore;
        this.tsFile = truststore;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    @Override
    public InputStream keyStoreInputStream() throws FileNotFoundException {
        return new FileInputStream(this.ksFile);
    }

    @Override
    public InputStream trustStoreInputStream() throws FileNotFoundException {
        if (this.tsFile == null) {
            return new FileInputStream(this.ksFile);
        }
        return new FileInputStream(this.tsFile);
    }

    @Override
    public String keyStorePassword() {
        return this.keyStorePassword;
    }

    @Override
    public String trustStorePassword() {
        return this.trustStorePassword;
    }

    @Override
    public String keyPassword() {
        return this.keyPassword;
    }
}

