/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.mqtt.examples;

import java.util.Random;
import org.apache.activemq.broker.BrokerService;
import org.apache.storm.mqtt.MqttLogger;
import org.fusesource.mqtt.client.BlockingConnection;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.QoS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttBrokerPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(MqttBrokerPublisher.class);
    private static BrokerService broker;
    private static BlockingConnection connection;

    public static void startBroker() throws Exception {
        LOG.info("Starting broker...");
        broker = new BrokerService();
        broker.addConnector("mqtt://localhost:1883");
        broker.setDataDirectory("target");
        broker.start();
        LOG.info("MQTT broker started");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    LOG.info("Shutting down MQTT broker...");
                    broker.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void startPublisher() throws Exception {
        MQTT client = new MQTT();
        client.setTracer(new MqttLogger());
        client.setHost("tcp://localhost:1883");
        client.setClientId("MqttBrokerPublisher");
        connection = client.blockingConnection();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    LOG.info("Shutting down MQTT client...");
                    connection.disconnect();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        connection.connect();
    }

    public static void publish() throws Exception {
        String topic = "/users/tgoetz/office/1234";
        Random rand = new Random();
        LOG.info("Publishing to topic {}", (Object)topic);
        LOG.info("Cntrl+C to exit.");
        while (true) {
            int temp = rand.nextInt(100);
            int hum = rand.nextInt(100);
            String payload = temp + "/" + hum;
            connection.publish(topic, payload.getBytes(), QoS.AT_LEAST_ONCE, false);
            Thread.sleep(500L);
        }
    }

    public static void main(String[] args) throws Exception {
        MqttBrokerPublisher.startBroker();
        MqttBrokerPublisher.startPublisher();
        MqttBrokerPublisher.publish();
    }
}

