/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.mqtt.examples;

import org.apache.storm.mqtt.MqttMessage;
import org.apache.storm.mqtt.MqttMessageMapper;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomMessageMapper
implements MqttMessageMapper {
    private static final Logger LOG = LoggerFactory.getLogger(CustomMessageMapper.class);

    @Override
    public Values toValues(MqttMessage message) {
        String topic = message.getTopic();
        String[] topicElements = topic.split("/");
        String[] payloadElements = new String(message.getMessage()).split("/");
        return new Values(new Object[]{topicElements[2], topicElements[4], topicElements[3], Float.valueOf(Float.parseFloat(payloadElements[0])), Float.valueOf(Float.parseFloat(payloadElements[1]))});
    }

    @Override
    public Fields outputFields() {
        return new Fields(new String[]{"user", "deviceId", "location", "temperature", "humidity"});
    }
}

