/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.mqtt.common;

import java.net.URI;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.storm.mqtt.ssl.KeyStoreLoader;

public class SslUtils {
    private SslUtils() {
    }

    public static void checkSslConfig(String url, KeyStoreLoader loader) {
        URI uri = URI.create(url);
        String scheme = uri.getScheme().toLowerCase();
        if (!(scheme.equals("tcp") || scheme.startsWith("tls") || scheme.startsWith("ssl"))) {
            throw new IllegalArgumentException("Unrecognized URI scheme: " + scheme);
        }
        if (!scheme.equalsIgnoreCase("tcp") && loader == null) {
            throw new IllegalStateException("A TLS/SSL MQTT URL was specified, but no KeyStoreLoader configured. A KeyStoreLoader implementation is required when using TLS/SSL.");
        }
    }

    public static SSLContext sslContext(String scheme, KeyStoreLoader keyStoreLoader) throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(keyStoreLoader.keyStoreInputStream(), keyStoreLoader.keyStorePassword().toCharArray());
        KeyStore ts = KeyStore.getInstance("JKS");
        ts.load(keyStoreLoader.trustStoreInputStream(), keyStoreLoader.trustStorePassword().toCharArray());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, keyStoreLoader.keyPassword().toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ts);
        SSLContext sc = SSLContext.getInstance(scheme.toUpperCase());
        TrustManager[] trustManagers = tmf.getTrustManagers();
        sc.init(kmf.getKeyManagers(), trustManagers, null);
        return sc;
    }
}

