/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.mqtt.common;

import java.io.Serializable;
import java.util.List;

public class MqttOptions
implements Serializable {
    private String url = "tcp://localhost:1883";
    private List<String> topics = null;
    private boolean cleanConnection = false;
    private String willTopic;
    private String willPayload;
    private int willQos = 1;
    private boolean willRetain = false;
    private long reconnectDelay = 10L;
    private long reconnectDelayMax = 30000L;
    private double reconnectBackOffMultiplier = 2.0;
    private long reconnectAttemptsMax = -1L;
    private long connectAttemptsMax = -1L;
    private String userName = "";
    private String password = "";
    private int qos = 1;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public void setTopics(List<String> topics) {
        this.topics = topics;
    }

    public boolean isCleanConnection() {
        return this.cleanConnection;
    }

    public void setCleanConnection(boolean cleanConnection) {
        this.cleanConnection = cleanConnection;
    }

    public String getWillTopic() {
        return this.willTopic;
    }

    public void setWillTopic(String willTopic) {
        this.willTopic = willTopic;
    }

    public String getWillPayload() {
        return this.willPayload;
    }

    public void setWillPayload(String willPayload) {
        this.willPayload = willPayload;
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public void setReconnectDelay(long reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    public long getReconnectDelayMax() {
        return this.reconnectDelayMax;
    }

    public void setReconnectDelayMax(long reconnectDelayMax) {
        this.reconnectDelayMax = reconnectDelayMax;
    }

    public double getReconnectBackOffMultiplier() {
        return this.reconnectBackOffMultiplier;
    }

    public void setReconnectBackOffMultiplier(double reconnectBackOffMultiplier) {
        this.reconnectBackOffMultiplier = reconnectBackOffMultiplier;
    }

    public long getReconnectAttemptsMax() {
        return this.reconnectAttemptsMax;
    }

    public void setReconnectAttemptsMax(long reconnectAttemptsMax) {
        this.reconnectAttemptsMax = reconnectAttemptsMax;
    }

    public long getConnectAttemptsMax() {
        return this.connectAttemptsMax;
    }

    public void setConnectAttemptsMax(long connectAttemptsMax) {
        this.connectAttemptsMax = connectAttemptsMax;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getQos() {
        return this.qos;
    }

    public void setQos(int qos) {
        if (qos < 0 || qos > 2) {
            throw new IllegalArgumentException("MQTT QoS must be >= 0 and <= 2");
        }
        this.qos = qos;
    }

    public int getWillQos() {
        return this.willQos;
    }

    public void setWillQos(int qos) {
        if (qos < 0 || qos > 2) {
            throw new IllegalArgumentException("MQTT Will QoS must be >= 0 and <= 2");
        }
        this.willQos = qos;
    }

    public boolean getWillRetain() {
        return this.willRetain;
    }

    public void setWillRetain(boolean retain) {
        this.willRetain = retain;
    }

    public static class Builder {
        private MqttOptions options = new MqttOptions();

        public Builder url(String url) {
            this.options.url = url;
            return this;
        }

        public Builder topics(List<String> topics) {
            this.options.topics = topics;
            return this;
        }

        public Builder cleanConnection(boolean cleanConnection) {
            this.options.cleanConnection = cleanConnection;
            return this;
        }

        public Builder willTopic(String willTopic) {
            this.options.willTopic = willTopic;
            return this;
        }

        public Builder willPayload(String willPayload) {
            this.options.willPayload = willPayload;
            return this;
        }

        public Builder willRetain(boolean retain) {
            this.options.willRetain = retain;
            return this;
        }

        public Builder willQos(int qos) {
            this.options.setWillQos(qos);
            return this;
        }

        public Builder reconnectDelay(long reconnectDelay) {
            this.options.reconnectDelay = reconnectDelay;
            return this;
        }

        public Builder reconnectDelayMax(long reconnectDelayMax) {
            this.options.reconnectDelayMax = reconnectDelayMax;
            return this;
        }

        public Builder reconnectBackOffMultiplier(double reconnectBackOffMultiplier) {
            this.options.reconnectBackOffMultiplier = reconnectBackOffMultiplier;
            return this;
        }

        public Builder reconnectAttemptsMax(long reconnectAttemptsMax) {
            this.options.reconnectAttemptsMax = reconnectAttemptsMax;
            return this;
        }

        public Builder connectAttemptsMax(long connectAttemptsMax) {
            this.options.connectAttemptsMax = connectAttemptsMax;
            return this;
        }

        public Builder userName(String userName) {
            this.options.userName = userName;
            return this;
        }

        public Builder password(String password) {
            this.options.password = password;
            return this;
        }

        public Builder qos(int qos) {
            this.options.setQos(qos);
            return this;
        }

        public MqttOptions build() {
            return this.options;
        }
    }
}

